/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.merge;

import java.util.Iterator;
import java.util.List;
import org.shaded.eclipse.jgit.diff.Sequence;
import org.shaded.eclipse.jgit.merge.MergeChunk;
import org.shaded.eclipse.jgit.util.IntList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeResult<S extends Sequence>
implements Iterable<MergeChunk> {
    private final List<S> sequences;
    private final IntList chunks = new IntList();
    private boolean containsConflicts = false;
    private static final MergeChunk.ConflictState[] states = MergeChunk.ConflictState.values();

    public MergeResult(List<S> sequences) {
        this.sequences = sequences;
    }

    public void add(int srcIdx, int begin, int end, MergeChunk.ConflictState conflictState) {
        this.chunks.add(conflictState.ordinal());
        this.chunks.add(srcIdx);
        this.chunks.add(begin);
        this.chunks.add(end);
        if (conflictState != MergeChunk.ConflictState.NO_CONFLICT) {
            this.containsConflicts = true;
        }
    }

    public List<S> getSequences() {
        return this.sequences;
    }

    @Override
    public Iterator<MergeChunk> iterator() {
        return new Iterator<MergeChunk>(){
            int idx;

            @Override
            public boolean hasNext() {
                return this.idx < MergeResult.this.chunks.size();
            }

            @Override
            public MergeChunk next() {
                MergeChunk.ConflictState state = states[MergeResult.this.chunks.get(this.idx++)];
                int srcIdx = MergeResult.this.chunks.get(this.idx++);
                int begin = MergeResult.this.chunks.get(this.idx++);
                int end = MergeResult.this.chunks.get(this.idx++);
                return new MergeChunk(srcIdx, begin, end, state);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean containsConflicts() {
        return this.containsConflicts;
    }
}

