/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GitOperationHelper {
    public void pushRevision(@NotNull File var1, @NotNull String var2) throws RepositoryException;

    public String commit(@NotNull File var1, @NotNull String var2, @NotNull String var3, @NotNull String var4) throws RepositoryException;

    @NotNull
    public String checkout(@Nullable File var1, @NotNull File var2, @NotNull String var3, @Nullable String var4) throws RepositoryException;

    public void fetch(@NotNull File var1, @NotNull String var2, boolean var3) throws RepositoryException;

    @NotNull
    public String getCurrentRevision(@NotNull File var1) throws RepositoryException;

    @Nullable
    public String getRevisionIfExists(@NotNull File var1, @NotNull String var2);

    @NotNull
    public String obtainLatestRevision() throws RepositoryException;

    @NotNull
    public List<VcsBranch> getOpenBranches(@NotNull GitRepository.GitRepositoryAccessData var1, File var2) throws RepositoryException;

    public boolean checkRevisionExistsInCacheRepository(@NotNull File var1, @NotNull String var2) throws IOException, RepositoryException;

    @Nullable
    public CommitContext getCommit(File var1, String var2) throws RepositoryException;

    public boolean merge(@NotNull File var1, @NotNull String var2, @NotNull String var3, @NotNull String var4) throws RepositoryException;

    public BuildRepositoryChanges extractCommits(File var1, String var2, String var3) throws RepositoryException;
}

