/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.plugins.git.ScpAwareUri;
import java.net.URI;
import java.net.URISyntaxException;
import org.jetbrains.annotations.Nullable;
import org.shaded.eclipse.jgit.transport.URIish;

public class UriUtils {
    static final String SSH_SCHEME = "ssh";
    static final String SCHEME_DELIMITER = "://";

    private UriUtils() {
    }

    @Nullable
    public static String extractUsername(String repositoryUrl) throws URISyntaxException {
        URIish uri = new URIish(repositoryUrl);
        String auth = uri.getUser();
        if (auth == null) {
            return null;
        }
        return auth;
    }

    public static boolean isSsh(ScpAwareUri repositoryUri) {
        return repositoryUri.getScheme().equals(SSH_SCHEME);
    }

    public static boolean isSsh(String repositoryUrl) {
        return repositoryUrl.startsWith("ssh://");
    }

    public static boolean hasScpSyntax(String s) {
        int scheme = s.indexOf(SCHEME_DELIMITER);
        if (scheme != -1) {
            return false;
        }
        int pathDefinitelyStartsHere = s.indexOf("/");
        if (pathDefinitelyStartsHere != -1) {
            s = s.substring(0, pathDefinitelyStartsHere);
        }
        return s.contains(":");
    }

    public static URI getUriViaProxy(GitRepository.GitRepositoryAccessData proxyAccessData, ScpAwareUri repositoryUri) throws URISyntaxException {
        return new URI(repositoryUri.getScheme(), proxyAccessData.proxyRegistrationInfo.getProxyUserName(), proxyAccessData.proxyRegistrationInfo.getProxyHost(), proxyAccessData.proxyRegistrationInfo.getProxyPort(), repositoryUri.getAbsolutePath(), repositoryUri.getRawQuery(), repositoryUri.getRawFragment());
    }
}

