/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.core.RepositoryUrlObfuscator;
import com.atlassian.bamboo.repository.RepositoryException;

class GitCommandException
extends RepositoryException {
    private final String stdout;
    private final String stderr;

    public GitCommandException(String message, String stdout, String stderr) {
        super(message);
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public GitCommandException(String message, Throwable cause, String stdout, String stderr) {
        super(message, cause);
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder(RepositoryUrlObfuscator.obfuscatePasswordInUrl((String)super.getMessage()));
        sb.append(", stderr:\n").append(this.stderr);
        if (!this.stdout.equals(this.stderr)) {
            sb.append("\nstdout:\n").append(this.stdout);
        }
        return sb.toString();
    }
}

