/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class GitCommandBuilder {
    private final List<String> commands = new ArrayList<String>();
    private String executable;
    private String branch;
    private String revision;
    private String source;
    private String destination;
    private String sshKeyFile;
    private String sshCommand;
    private boolean sshCompression;
    private boolean verbose;
    private boolean maxVerboseOutput;
    private boolean shallowClone;

    protected GitCommandBuilder(String ... commands) {
        this.commands.addAll(Arrays.asList(commands));
    }

    public GitCommandBuilder executable(String executable) {
        this.executable = executable;
        return this;
    }

    public GitCommandBuilder branch(String branch) {
        this.branch = branch;
        return this;
    }

    public GitCommandBuilder revision(String revision) {
        this.revision = revision;
        return this;
    }

    public GitCommandBuilder destination(String destination) {
        this.destination = destination;
        return this;
    }

    public GitCommandBuilder source(String source) {
        this.source = source;
        return this;
    }

    public GitCommandBuilder verbose(Boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public GitCommandBuilder sshCommand(String sshCommand) {
        this.sshCommand = sshCommand;
        return this;
    }

    public GitCommandBuilder sshKeyFile(String sshKeyFile) {
        this.sshKeyFile = sshKeyFile;
        return this;
    }

    public GitCommandBuilder sshCompression(boolean sshCompression) {
        this.sshCompression = sshCompression;
        return this;
    }

    public GitCommandBuilder maxVerboseOutput(boolean maxVerboseOutput) {
        this.maxVerboseOutput = maxVerboseOutput;
        return this;
    }

    public GitCommandBuilder shallowClone() {
        this.shallowClone = true;
        return this;
    }

    public GitCommandBuilder append(String argument) {
        this.commands.add(argument);
        return this;
    }

    public List<String> build() {
        ArrayList<String> commandArgs = new ArrayList<String>();
        if (this.executable != null) {
            commandArgs.add(this.executable);
        } else {
            commandArgs.add("git");
        }
        commandArgs.addAll(this.commands);
        if (this.verbose || this.maxVerboseOutput) {
            commandArgs.add("--verbose");
        }
        if (StringUtils.isNotBlank((String)this.branch)) {
            commandArgs.add("--branch");
            commandArgs.add(this.branch);
        }
        if (this.revision != null) {
            commandArgs.add("--rev");
            commandArgs.add(this.revision);
        }
        if (this.source != null) {
            commandArgs.add(this.source);
        }
        if (this.destination != null) {
            commandArgs.add(this.destination);
        }
        if (this.shallowClone) {
            commandArgs.add("--depth");
            commandArgs.add("1");
        }
        return commandArgs;
    }

    public Map<String, String> prepareEnvironment() {
        HashMap<String, String> environment = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)this.sshCommand)) {
            environment.put("GIT_SSH", this.sshCommand);
            environment.put("GIT_COMMITTER_NAME", "Bamboo");
            environment.put("GIT_COMMITTER_EMAIL", "bamboo@atlassian.com");
            environment.put("GIT_AUTHOR_NAME", "Bamboo");
        }
        return environment;
    }

    public String toString() {
        return this.build().toString();
    }
}

