/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.lib;

import org.shaded.eclipse.jgit.lib.Config;

public class CoreConfig {
    public static final Config.SectionParser<CoreConfig> KEY = new Config.SectionParser<CoreConfig>(){

        @Override
        public CoreConfig parse(Config cfg) {
            return new CoreConfig(cfg);
        }
    };
    private final int compression;
    private final int packIndexVersion;
    private final boolean logAllRefUpdates;
    private final String excludesfile;

    private CoreConfig(Config rc) {
        this.compression = rc.getInt("core", "compression", -1);
        this.packIndexVersion = rc.getInt("pack", "indexversion", 2);
        this.logAllRefUpdates = rc.getBoolean("core", "logallrefupdates", true);
        this.excludesfile = rc.getString("core", null, "excludesfile");
    }

    public int getCompression() {
        return this.compression;
    }

    public int getPackIndexVersion() {
        return this.packIndexVersion;
    }

    public boolean isLogAllRefUpdates() {
        return this.logAllRefUpdates;
    }

    public String getExcludesFile() {
        return this.excludesfile;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AutoCRLF {
        FALSE,
        TRUE,
        INPUT;

    }
}

