/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plugins.git.GitHubRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataImpl;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.rest.util.Get;
import com.atlassian.bamboo.security.StringEncrypter;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.opensymphony.webwork.dispatcher.json.JSONArray;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LoadGitHubRepositories
extends PlanActionSupport
implements PlanEditSecurityAware {
    private static final Logger log = Logger.getLogger(LoadGitHubRepositories.class);
    private static final String GITHUB_API_BASE_URL = new SystemProperty(false, new String[]{"atlassian.bamboo.github.api.base.url", "ATLASSIAN_BAMBOO_GITHUB_API_BASE_URL"}).getValue("http://github.com/api/v2/json/");
    private String username;
    private String password;
    private long repositoryId;
    private GitHubRepository githubRepository;
    private RepositoryDefinitionManager repositoryDefinitionManager;
    private StringEncrypter stringEncrypter;

    public String doLoad() throws Exception {
        return "success";
    }

    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        RepositoryDataImpl repositoryDefinition;
        Repository repository;
        GitHubRepository ghRepository;
        RepositoryDataEntity repositoryDataEntity;
        Map<String, List<String>> gitHubRepositories = null;
        if (this.repositoryId > 0L && StringUtils.isBlank((String)this.password) && (repositoryDataEntity = this.repositoryDefinitionManager.getRepositoryDataEntity(this.repositoryId)) != null && (ghRepository = (GitHubRepository)((Object)Narrow.to((Object)(repository = (repositoryDefinition = new RepositoryDataImpl(repositoryDataEntity)).getRepository()), GitHubRepository.class))) != null) {
            this.password = this.stringEncrypter.decrypt(ghRepository.getPassword());
        }
        if (StringUtils.isBlank((String)this.username)) {
            this.addFieldError("username", this.getText("repository.github.error.emptyUsername"));
        }
        this.checkFieldXssSafety("username", this.username);
        if (!this.hasErrors()) {
            try {
                gitHubRepositories = this.getGitHubRepositores();
            }
            catch (FileNotFoundException e) {
                this.addFieldError("username", this.getText("repository.github.error.invalidUsername"));
            }
            catch (IllegalArgumentException e) {
                this.addFieldError("username", this.getText("repository.github.error.invalidUsername"));
            }
            catch (JSONException e) {
                this.addFieldError("username", this.getText("repository.github.error.invalidUsername"));
            }
            catch (Exception e) {
                this.addActionError(this.getText("repository.github.ajaxError") + e.toString());
                log.error((Object)("Could not load bitbucket repositories for " + this.username + "."), (Throwable)e);
            }
        }
        JSONObject jsonObject = super.getJsonObject();
        if (this.hasErrors()) {
            return jsonObject;
        }
        ArrayList<JSONObject> data = new ArrayList<JSONObject>();
        for (Map.Entry<String, List<String>> entry : gitHubRepositories.entrySet()) {
            String repository2 = entry.getKey();
            for (String branch : entry.getValue()) {
                data.add(new JSONObject().put("value", (Object)branch).put("text", (Object)branch).put("supportedValues", (Object)new String[]{repository2}));
            }
        }
        jsonObject.put("repositoryBranchFilter", (Object)new JSONObject().put("data", data));
        jsonObject.put("gitHubRepositories", gitHubRepositories);
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject getJSONResponseFromUrl(String url) throws Exception {
        Get call = new Get(url);
        call.setBasicCredentials(this.username, this.password);
        try {
            call.execute();
            JSONObject jSONObject = new JSONObject(IOUtils.toString((InputStream)call.getResponseAsStream()));
            return jSONObject;
        }
        finally {
            call.release();
        }
    }

    @NotNull
    private List<String> getRepositoryBranches(String repository) throws Exception {
        JSONObject json = this.getJSONResponseFromUrl(GITHUB_API_BASE_URL + "repos/show/" + repository + "/branches");
        return this.getRepositoryBranches(json);
    }

    @NotNull
    protected List<String> getRepositoryBranches(JSONObject json) throws Exception {
        ArrayList<String> repositoryBranches = new ArrayList<String>();
        JSONObject branches = json.getJSONObject("branches");
        if (branches != null) {
            Iterator it = branches.keys();
            while (it.hasNext()) {
                String branch = (String)it.next();
                if (branch.equals("master")) {
                    repositoryBranches.add(0, branch);
                    continue;
                }
                repositoryBranches.add(branch);
            }
        }
        return repositoryBranches;
    }

    private void addRepositoriesFromJson(@NotNull Map<String, List<String>> repositories, @NotNull JSONObject json) throws Exception {
        this.addRepositoriesFromJson(repositories, json, false);
    }

    private void addRepositoriesFromJson(@NotNull Map<String, List<String>> repositories, @NotNull JSONObject json, boolean skipPublic) throws Exception {
        JSONArray jsonRepositories = json.getJSONArray("repositories");
        for (int index = 0; index < jsonRepositories.length(); ++index) {
            JSONObject jsonRepository = jsonRepositories.getJSONObject(index);
            if (skipPublic && !jsonRepository.getBoolean("private")) continue;
            String owner = jsonRepository.getString("owner");
            String name = jsonRepository.getString("name");
            String repository = owner + "/" + name;
            repositories.put(repository, this.getRepositoryBranches(repository));
        }
    }

    @NotNull
    private Map<String, List<String>> getGitHubRepositores() throws Exception {
        JSONObject json;
        LinkedHashMap<String, List<String>> githubRepositories = new LinkedHashMap<String, List<String>>();
        if (StringUtils.isNotBlank((String)this.password)) {
            json = this.getJSONResponseFromUrl(GITHUB_API_BASE_URL + "repos/pushable");
            if (json.has("error") && json.getString("error").equals("not authorized")) {
                if (this.getPlan() != null) {
                    this.addFieldError("username", this.getText("repository.github.error.notAuthorized"));
                } else {
                    this.addFieldError("temporary.password", this.getText("repository.github.error.notAuthorized"));
                }
                return githubRepositories;
            }
            this.addRepositoriesFromJson(githubRepositories, json);
            JSONObject organizationJson = this.getJSONResponseFromUrl(GITHUB_API_BASE_URL + "organizations/repositories?owned=1");
            if (organizationJson.has("error") && organizationJson.getString("error").equals("not authorized")) {
                if (this.getPlan() != null) {
                    this.addFieldError("username", this.getText("repository.github.error.notAuthorized"));
                } else {
                    this.addFieldError("temporary.password", this.getText("repository.github.error.notAuthorized"));
                }
                return githubRepositories;
            }
            this.addRepositoriesFromJson(githubRepositories, organizationJson, true);
            organizationJson = this.getJSONResponseFromUrl(GITHUB_API_BASE_URL + "organizations/repositories");
            this.addRepositoriesFromJson(githubRepositories, organizationJson);
        }
        json = this.getJSONResponseFromUrl(GITHUB_API_BASE_URL + "repos/show/" + this.username);
        this.addRepositoriesFromJson(githubRepositories, json);
        if (githubRepositories.isEmpty()) {
            this.addFieldError("username", this.getText("repository.bitbucket.error.noRepositories", Arrays.asList(this.username)));
        }
        return githubRepositories;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRepositoryId(long repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void setRepositoryDefinitionManager(RepositoryDefinitionManager repositoryDefinitionManager) {
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    public void setStringEncrypter(StringEncrypter stringEncrypter) {
        this.stringEncrypter = stringEncrypter;
    }
}

