/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.treewalk.filter;

import org.shaded.eclipse.jgit.dircache.DirCacheEntry;
import org.shaded.eclipse.jgit.dircache.DirCacheIterator;
import org.shaded.eclipse.jgit.treewalk.TreeWalk;
import org.shaded.eclipse.jgit.treewalk.filter.TreeFilter;

public class SkipWorkTreeFilter
extends TreeFilter {
    private final int treeIdx;

    public SkipWorkTreeFilter(int treeIdx) {
        this.treeIdx = treeIdx;
    }

    public boolean include(TreeWalk walker) {
        DirCacheIterator i = walker.getTree(this.treeIdx, DirCacheIterator.class);
        if (i == null) {
            return true;
        }
        DirCacheEntry e = i.getDirCacheEntry();
        return e == null || !e.isSkipWorkTree();
    }

    public boolean shouldBeRecursive() {
        return false;
    }

    public TreeFilter clone() {
        return this;
    }

    public String toString() {
        return "SkipWorkTree(" + this.treeIdx + ")";
    }
}

