/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.errors.PackProtocolException;
import org.shaded.eclipse.jgit.lib.Constants;
import org.shaded.eclipse.jgit.lib.MutableObjectId;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.util.IO;
import org.shaded.eclipse.jgit.util.RawParseUtils;

public class PacketLineIn {
    public static final String END = new StringBuilder(0).toString();
    private final InputStream in;
    private final byte[] lineBuffer;
    boolean expectShallowInNextLine = false;
    public Set<ObjectId> shallows = new HashSet<ObjectId>();
    public Set<ObjectId> unshallows = new HashSet<ObjectId>();

    public PacketLineIn(InputStream i) {
        this.in = i;
        this.lineBuffer = new byte[1000];
    }

    private String readStringAndConsumeAllShallows() throws IOException {
        String line;
        while (true) {
            if ((line = this.readString()).startsWith("shallow ")) {
                this.shallows.add(ObjectId.fromString(line.substring("shallow ".length())));
                continue;
            }
            if (!line.startsWith("unshallow ")) break;
            this.unshallows.add(ObjectId.fromString(line.substring("unshallow ".length())));
        }
        if (line.length() == 0) {
            return this.readString();
        }
        throw new PackProtocolException("expected \"shallow {objectId}\", got " + line);
    }

    AckNackResult readACK(MutableObjectId returnedId) throws IOException {
        String line;
        if (this.expectShallowInNextLine) {
            line = this.readStringAndConsumeAllShallows();
            this.expectShallowInNextLine = false;
        } else {
            String nextLine = this.readString();
            if (nextLine.startsWith("shallow ")) {
                this.shallows.add(ObjectId.fromString(nextLine.substring("shallow ".length())));
                line = this.readStringAndConsumeAllShallows();
            } else {
                line = nextLine;
            }
        }
        if (line.length() == 0) {
            throw new PackProtocolException(JGitText.get().expectedACKNAKFoundEOF);
        }
        if ("NAK".equals(line)) {
            return AckNackResult.NAK;
        }
        if (line.startsWith("ACK ")) {
            returnedId.fromString(line.substring(4, 44));
            if (line.length() == 44) {
                return AckNackResult.ACK;
            }
            String arg = line.substring(44);
            if (arg.equals(" continue")) {
                return AckNackResult.ACK_CONTINUE;
            }
            if (arg.equals(" common")) {
                return AckNackResult.ACK_COMMON;
            }
            if (arg.equals(" ready")) {
                return AckNackResult.ACK_READY;
            }
        }
        if (line.startsWith("ERR ")) {
            throw new PackProtocolException(line.substring(4));
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedACKNAKGot, line));
    }

    public String readString() throws IOException {
        int len = this.readLength();
        if (len == 0) {
            return END;
        }
        if ((len -= 4) == 0) {
            return "";
        }
        byte[] raw = len <= this.lineBuffer.length ? this.lineBuffer : new byte[len];
        IO.readFully(this.in, raw, 0, len);
        if (raw[len - 1] == 10) {
            --len;
        }
        return RawParseUtils.decode(Constants.CHARSET, raw, 0, len);
    }

    public String readStringRaw() throws IOException {
        int len = this.readLength();
        if (len == 0) {
            return END;
        }
        byte[] raw = (len -= 4) <= this.lineBuffer.length ? this.lineBuffer : new byte[len];
        IO.readFully(this.in, raw, 0, len);
        return RawParseUtils.decode(Constants.CHARSET, raw, 0, len);
    }

    int readLength() throws IOException {
        IO.readFully(this.in, this.lineBuffer, 0, 4);
        try {
            int len = RawParseUtils.parseHexInt16(this.lineBuffer, 0);
            if (len != 0 && len < 4) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return len;
        }
        catch (ArrayIndexOutOfBoundsException err) {
            throw new IOException(MessageFormat.format(JGitText.get().invalidPacketLineHeader, "" + (char)this.lineBuffer[0] + (char)this.lineBuffer[1] + (char)this.lineBuffer[2] + (char)this.lineBuffer[3]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AckNackResult {
        NAK,
        ACK,
        ACK_CONTINUE,
        ACK_COMMON,
        ACK_READY;

    }
}

