/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.storage.pack;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.errors.CorruptObjectException;
import org.shaded.eclipse.jgit.util.IO;

public abstract class DeltaStream
extends InputStream {
    private static final int CMD_COPY = 0;
    private static final int CMD_INSERT = 1;
    private static final int CMD_EOF = 2;
    private final InputStream deltaStream;
    private long baseSize;
    private long resultSize;
    private final byte[] cmdbuf = new byte[512];
    private int cmdptr;
    private int cmdcnt;
    private InputStream baseStream;
    private long baseOffset;
    private int curcmd;
    private long copyOffset;
    private int copySize;

    public DeltaStream(InputStream deltaStream) throws IOException {
        int c;
        this.deltaStream = deltaStream;
        if (!this.fill(this.cmdbuf.length)) {
            throw new EOFException();
        }
        int shift = 0;
        do {
            c = this.cmdbuf[this.cmdptr++] & 0xFF;
            this.baseSize |= (long)((c & 0x7F) << shift);
            shift += 7;
        } while ((c & 0x80) != 0);
        shift = 0;
        do {
            c = this.cmdbuf[this.cmdptr++] & 0xFF;
            this.resultSize |= (long)((c & 0x7F) << shift);
            shift += 7;
        } while ((c & 0x80) != 0);
        this.curcmd = this.next();
    }

    protected abstract InputStream openBase() throws IOException;

    protected abstract long getBaseSize() throws IOException;

    public long getSize() {
        return this.resultSize;
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int n = this.read(buf, 0, 1);
        return n == 1 ? buf[0] & 0xFF : -1;
    }

    public void close() throws IOException {
        this.deltaStream.close();
        if (this.baseStream != null) {
            this.baseStream.close();
        }
    }

    public long skip(long len) throws IOException {
        long act = 0L;
        while (0L < len) {
            long n = Math.min(len, (long)this.copySize);
            switch (this.curcmd) {
                case 0: {
                    this.copyOffset += n;
                    break;
                }
                case 1: {
                    this.cmdptr = (int)((long)this.cmdptr + n);
                    break;
                }
                case 2: {
                    return act;
                }
                default: {
                    throw new CorruptObjectException(JGitText.get().unsupportedCommand0);
                }
            }
            act += n;
            len -= n;
            this.copySize = (int)((long)this.copySize - n);
            if (this.copySize != 0) continue;
            this.curcmd = this.next();
        }
        return act;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int act = 0;
        while (0 < len) {
            int n = Math.min(len, this.copySize);
            switch (this.curcmd) {
                case 0: {
                    this.seekBase();
                    n = this.baseStream.read(buf, off, n);
                    if (n < 0) {
                        throw new CorruptObjectException(JGitText.get().baseLengthIncorrect);
                    }
                    this.copyOffset += (long)n;
                    this.baseOffset = this.copyOffset;
                    break;
                }
                case 1: {
                    System.arraycopy(this.cmdbuf, this.cmdptr, buf, off, n);
                    this.cmdptr += n;
                    break;
                }
                case 2: {
                    return 0 < act ? act : -1;
                }
                default: {
                    throw new CorruptObjectException(JGitText.get().unsupportedCommand0);
                }
            }
            act += n;
            off += n;
            len -= n;
            this.copySize -= n;
            if (this.copySize != 0) continue;
            this.curcmd = this.next();
        }
        return act;
    }

    private boolean fill(int need) throws IOException {
        int n = this.have();
        if (need < n) {
            return true;
        }
        if (n == 0) {
            this.cmdptr = 0;
            this.cmdcnt = 0;
        } else if (this.cmdbuf.length - this.cmdptr < need) {
            System.arraycopy(this.cmdbuf, this.cmdptr, this.cmdbuf, 0, n);
            this.cmdptr = 0;
            this.cmdcnt = n;
        }
        do {
            if ((n = this.deltaStream.read(this.cmdbuf, this.cmdcnt, this.cmdbuf.length - this.cmdcnt)) < 0) {
                return 0 < this.have();
            }
            this.cmdcnt += n;
        } while (this.cmdcnt < this.cmdbuf.length);
        return true;
    }

    private int next() throws IOException {
        int cmd;
        if (!this.fill(8)) {
            return 2;
        }
        if (((cmd = this.cmdbuf[this.cmdptr++] & 0xFF) & 0x80) != 0) {
            this.copyOffset = 0L;
            if ((cmd & 1) != 0) {
                this.copyOffset = this.cmdbuf[this.cmdptr++] & 0xFF;
            }
            if ((cmd & 2) != 0) {
                this.copyOffset |= (long)((this.cmdbuf[this.cmdptr++] & 0xFF) << 8);
            }
            if ((cmd & 4) != 0) {
                this.copyOffset |= (long)((this.cmdbuf[this.cmdptr++] & 0xFF) << 16);
            }
            if ((cmd & 8) != 0) {
                this.copyOffset |= (long)((this.cmdbuf[this.cmdptr++] & 0xFF) << 24);
            }
            this.copySize = 0;
            if ((cmd & 0x10) != 0) {
                this.copySize = this.cmdbuf[this.cmdptr++] & 0xFF;
            }
            if ((cmd & 0x20) != 0) {
                this.copySize |= (this.cmdbuf[this.cmdptr++] & 0xFF) << 8;
            }
            if ((cmd & 0x40) != 0) {
                this.copySize |= (this.cmdbuf[this.cmdptr++] & 0xFF) << 16;
            }
            if (this.copySize == 0) {
                this.copySize = 65536;
            }
            return 0;
        }
        if (cmd != 0) {
            this.fill(cmd);
            this.copySize = cmd;
            return 1;
        }
        throw new CorruptObjectException(JGitText.get().unsupportedCommand0);
    }

    private int have() {
        return this.cmdcnt - this.cmdptr;
    }

    private void seekBase() throws IOException {
        if (this.baseStream == null) {
            this.baseStream = this.openBase();
            if (this.getBaseSize() != this.baseSize) {
                throw new CorruptObjectException(JGitText.get().baseLengthIncorrect);
            }
            IO.skipFully(this.baseStream, this.copyOffset);
            this.baseOffset = this.copyOffset;
        } else if (this.baseOffset < this.copyOffset) {
            IO.skipFully(this.baseStream, this.copyOffset - this.baseOffset);
            this.baseOffset = this.copyOffset;
        } else if (this.baseOffset > this.copyOffset) {
            this.baseStream.close();
            this.baseStream = this.openBase();
            IO.skipFully(this.baseStream, this.copyOffset);
            this.baseOffset = this.copyOffset;
        }
    }
}

