/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.storage.file;

import java.io.File;

public class FileSnapshot {
    public static final FileSnapshot DIRTY = new FileSnapshot(-1L, -1L);
    public static final FileSnapshot MISSING_FILE = new FileSnapshot(0L, 0L){

        public boolean isModified(File path) {
            return path.exists();
        }
    };
    private final long lastModified;
    private volatile long lastRead;
    private boolean cannotBeRacilyClean;

    public static FileSnapshot save(File path) {
        long read = System.currentTimeMillis();
        long modified = path.lastModified();
        return new FileSnapshot(read, modified);
    }

    public static FileSnapshot save(long modified) {
        long read = System.currentTimeMillis();
        return new FileSnapshot(read, modified);
    }

    private FileSnapshot(long read, long modified) {
        this.lastRead = read;
        this.lastModified = modified;
        this.cannotBeRacilyClean = this.notRacyClean(read);
    }

    public long lastModified() {
        return this.lastModified;
    }

    public boolean isModified(File path) {
        return this.isModified(path.lastModified());
    }

    public void setClean(FileSnapshot other) {
        long now = other.lastRead;
        if (this.notRacyClean(now)) {
            this.cannotBeRacilyClean = true;
        }
        this.lastRead = now;
    }

    public boolean equals(FileSnapshot other) {
        return this.lastModified == other.lastModified;
    }

    public boolean equals(Object other) {
        if (other instanceof FileSnapshot) {
            return this.equals((FileSnapshot)other);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.lastModified;
    }

    private boolean notRacyClean(long read) {
        return read - this.lastModified > 2500L;
    }

    private boolean isModified(long currLastModified) {
        if (this.lastModified != currLastModified) {
            return true;
        }
        if (this.cannotBeRacilyClean) {
            return false;
        }
        if (this.notRacyClean(this.lastRead)) {
            return false;
        }
        this.lastRead = System.currentTimeMillis();
        return !this.notRacyClean(this.lastRead);
    }
}

