/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.lib;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import org.shaded.eclipse.jgit.errors.LargeObjectException;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.lib.ObjectStream;
import org.shaded.eclipse.jgit.util.IO;

public abstract class ObjectLoader {
    public abstract int getType();

    public abstract long getSize();

    public boolean isLarge() {
        try {
            this.getCachedBytes();
            return false;
        }
        catch (LargeObjectException tooBig) {
            return true;
        }
    }

    public final byte[] getBytes() throws LargeObjectException {
        return ObjectLoader.cloneArray(this.getCachedBytes());
    }

    public final byte[] getBytes(int sizeLimit) throws LargeObjectException, MissingObjectException, IOException {
        byte[] cached = this.getCachedBytes(sizeLimit);
        try {
            return ObjectLoader.cloneArray(cached);
        }
        catch (OutOfMemoryError tooBig) {
            throw new LargeObjectException.OutOfMemory(tooBig);
        }
    }

    public abstract byte[] getCachedBytes() throws LargeObjectException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCachedBytes(int sizeLimit) throws LargeObjectException, MissingObjectException, IOException {
        if (!this.isLarge()) {
            return this.getCachedBytes();
        }
        ObjectStream in = this.openStream();
        try {
            byte[] buf;
            long sz = in.getSize();
            if ((long)sizeLimit < sz) {
                throw new LargeObjectException.ExceedsLimit(sizeLimit, sz);
            }
            if (Integer.MAX_VALUE < sz) {
                throw new LargeObjectException.ExceedsByteArrayLimit();
            }
            try {
                buf = new byte[(int)sz];
            }
            catch (OutOfMemoryError notEnoughHeap) {
                throw new LargeObjectException.OutOfMemory(notEnoughHeap);
            }
            IO.readFully(in, buf, 0, buf.length);
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public abstract ObjectStream openStream() throws MissingObjectException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(OutputStream out) throws MissingObjectException, IOException {
        block7: {
            if (this.isLarge()) {
                ObjectStream in = this.openStream();
                try {
                    int n;
                    long sz = in.getSize();
                    byte[] tmp = new byte[8192];
                    for (long copied = 0L; copied < sz; copied += (long)n) {
                        n = in.read(tmp);
                        if (n < 0) {
                            throw new EOFException();
                        }
                        out.write(tmp, 0, n);
                    }
                    if (0 <= in.read()) {
                        throw new EOFException();
                    }
                    break block7;
                }
                finally {
                    in.close();
                }
            }
            out.write(this.getCachedBytes());
        }
    }

    private static byte[] cloneArray(byte[] data) {
        byte[] copy = new byte[data.length];
        System.arraycopy(data, 0, copy, 0, data.length);
        return copy;
    }

    public static class SmallObject
    extends ObjectLoader {
        private final int type;
        private final byte[] data;

        public SmallObject(int type, byte[] data) {
            this.type = type;
            this.data = data;
        }

        public int getType() {
            return this.type;
        }

        public long getSize() {
            return this.getCachedBytes().length;
        }

        public boolean isLarge() {
            return false;
        }

        public byte[] getCachedBytes() {
            return this.data;
        }

        public ObjectStream openStream() {
            return new ObjectStream.SmallStream(this);
        }
    }
}

