/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.blame;

import java.io.IOException;
import org.shaded.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.lib.AnyObjectId;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.revwalk.RevCommit;
import org.shaded.eclipse.jgit.revwalk.RevWalk;

final class ReverseWalk
extends RevWalk {
    ReverseWalk(Repository repo) {
        super(repo);
    }

    public ReverseCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ReverseCommit c = (ReverseCommit)super.next();
        if (c == null) {
            return null;
        }
        for (int pIdx = 0; pIdx < c.getParentCount(); ++pIdx) {
            ((ReverseCommit)c.getParent(pIdx)).addChild(c);
        }
        return c;
    }

    protected RevCommit createCommit(AnyObjectId id) {
        return new ReverseCommit(id);
    }

    static final class ReverseCommit
    extends RevCommit {
        private static final ReverseCommit[] NO_CHILDREN = new ReverseCommit[0];
        private ReverseCommit[] children = NO_CHILDREN;

        ReverseCommit(AnyObjectId id) {
            super(id);
        }

        void addChild(ReverseCommit c) {
            int cnt = this.children.length;
            if (cnt == 0) {
                this.children = new ReverseCommit[]{c};
            } else if (cnt == 1) {
                this.children = new ReverseCommit[]{c, this.children[0]};
            } else {
                ReverseCommit[] n = new ReverseCommit[1 + cnt];
                n[0] = c;
                System.arraycopy(this.children, 0, n, 1, cnt);
                this.children = n;
            }
        }

        int getChildCount() {
            return this.children.length;
        }

        ReverseCommit getChild(int nth) {
            return this.children[nth];
        }
    }
}

