/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.core.RepositoryUrlObfuscator;
import com.atlassian.bamboo.plugins.git.GitCommandBuilder;
import com.atlassian.bamboo.plugins.git.GitCommandException;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.ssh.ProxyErrorReceiver;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.LineOutputHandler;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.PluggableProcessHandler;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.StringOutputHandler;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shaded.eclipse.jgit.transport.RefSpec;

class GitCommandProcessor
implements Serializable,
ProxyErrorReceiver {
    private static final Logger log = Logger.getLogger(GitCommandProcessor.class);
    static final Pattern gitVersionPattern = Pattern.compile("^git version (.*)");
    private final String gitExecutable;
    private final BuildLogger buildLogger;
    private final int commandTimeoutInMinutes;
    private final boolean maxVerboseOutput;
    private String proxyErrorMessage;
    private Throwable proxyException;
    private String sshCommand;

    public GitCommandProcessor(@Nullable String gitExecutable, @NotNull BuildLogger buildLogger, int commandTimeoutInMinutes, boolean maxVerboseOutput) {
        this.gitExecutable = gitExecutable;
        this.buildLogger = buildLogger;
        this.commandTimeoutInMinutes = commandTimeoutInMinutes;
        this.maxVerboseOutput = maxVerboseOutput;
    }

    public void checkGitExistenceInSystem(@NotNull File workingDirectory) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.createCommandBuilder("version");
        GitStringOutputHandler outputHandler = new GitStringOutputHandler();
        try {
            this.runCommand(commandBuilder, workingDirectory, outputHandler);
            String output = outputHandler.getOutput();
            Matcher matcher = gitVersionPattern.matcher(output);
            if (!matcher.find()) {
                String errorMessage = "Git Executable capability `" + this.gitExecutable + "' does not seem to be a git client. Is it properly set?";
                log.error((Object)(errorMessage + " Output:\n" + output));
                throw new RepositoryException(errorMessage);
            }
        }
        catch (GitCommandException e) {
            throw new RepositoryException("Git not found. Is Git Executable capability properly set in configuration?", (Throwable)((Object)e));
        }
    }

    public void runInitCommand(@NotNull File workingDirectory) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.createCommandBuilder("init");
        this.runCommand(commandBuilder, workingDirectory, new LoggingOutputHandler(this.buildLogger));
    }

    public void runFetchCommand(@NotNull File workingDirectory, @NotNull GitRepository.GitRepositoryAccessData accessData, RefSpec refSpec, boolean useShallow) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.createCommandBuilder("fetch", accessData.repositoryUrl, refSpec.toString(), "--update-head-ok");
        if (useShallow) {
            commandBuilder.shallowClone();
        }
        if (accessData.verboseLogs) {
            commandBuilder.verbose(true);
            commandBuilder.append("--progress");
        }
        this.runCommand(commandBuilder, workingDirectory, new LoggingOutputHandler(this.buildLogger));
    }

    public void runCheckoutCommand(@NotNull File workingDirectory, String revision) throws RepositoryException {
        String possibleBranch = this.getPossibleBranchNameForCheckout(workingDirectory, revision);
        String destination = revision;
        if (StringUtils.isNotBlank((String)possibleBranch)) {
            destination = possibleBranch;
        }
        GitCommandBuilder commandBuilder = this.createCommandBuilder("checkout", "-f", destination);
        this.runCommand(commandBuilder, workingDirectory, new LoggingOutputHandler(this.buildLogger));
    }

    public void runSubmoduleUpdateCommand(@NotNull File workingDirectory) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.createCommandBuilder("submodule", "update", "--init", "--recursive");
        this.runCommand(commandBuilder, workingDirectory, new LoggingOutputHandler(this.buildLogger));
    }

    private String getPossibleBranchNameForCheckout(File workingDirectory, String revision) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.createCommandBuilder("log", "-1", "--format=%d", "--decorate=full");
        commandBuilder.append(revision);
        GitStringOutputHandler outputHandler = new GitStringOutputHandler();
        this.runCommand(commandBuilder, workingDirectory, outputHandler);
        String revisionDescription = outputHandler.getOutput();
        if (StringUtils.isNotBlank((String)revisionDescription)) {
            HashSet possibleBranches = Sets.newHashSet((Iterable)Splitter.on((char)',').trimResults().split((CharSequence)CharMatcher.anyOf((CharSequence)"()").removeFrom((CharSequence)StringUtils.trim((String)revisionDescription))));
            for (String possibleBranch : possibleBranches) {
                if (!possibleBranch.startsWith("refs/heads/")) continue;
                return StringUtils.removeStart((String)possibleBranch, (String)"refs/heads/");
            }
        }
        return "";
    }

    private GitCommandBuilder createCommandBuilder(String ... commands) {
        return new GitCommandBuilder(commands).executable(this.gitExecutable).sshCommand(this.sshCommand);
    }

    public void reportProxyError(String message, Throwable exception) {
        this.proxyErrorMessage = message;
        this.proxyException = exception;
    }

    private void runCommand(@NotNull GitCommandBuilder commandBuilder, @NotNull File workingDirectory, @NotNull GitOutputHandler outputHandler) throws RepositoryException {
        workingDirectory.mkdirs();
        PluggableProcessHandler handler = new PluggableProcessHandler();
        handler.setOutputHandler((OutputHandler)outputHandler);
        handler.setErrorHandler((OutputHandler)outputHandler);
        List<String> commandArgs = commandBuilder.build();
        if (this.maxVerboseOutput) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String s : RepositoryUrlObfuscator.obfuscatePasswordsInUrls(commandArgs)) {
                stringBuilder.append(s).append(" ");
            }
            this.buildLogger.addBuildLogEntry(stringBuilder.toString());
        }
        ExternalProcessBuilder externalProcessBuilder = new ExternalProcessBuilder().command(commandArgs, workingDirectory).handler((ProcessHandler)handler);
        Map<String, String> environment = commandBuilder.prepareEnvironment();
        if (!environment.isEmpty()) {
            externalProcessBuilder.env(environment);
        }
        ExternalProcess process = externalProcessBuilder.build();
        process.setTimeout(TimeUnit.MINUTES.toMillis(this.commandTimeoutInMinutes));
        process.execute();
        if (!handler.succeeded()) {
            throw new GitCommandException("command " + RepositoryUrlObfuscator.obfuscatePasswordsInUrls(commandArgs) + " failed. Working directory was `" + workingDirectory + "'.", this.proxyException != null ? this.proxyException : handler.getException(), outputHandler.getStdout(), this.proxyErrorMessage != null ? "SSH Proxy error: " + this.proxyErrorMessage : outputHandler.getStdout());
        }
    }

    public boolean runMergeCommand(File workspaceDir, String targetRevision) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.createCommandBuilder("merge", "--no-commit", targetRevision);
        LoggingOutputHandler outputHandler = new LoggingOutputHandler(this.buildLogger);
        this.runCommand(commandBuilder, workspaceDir, outputHandler);
        return outputHandler.getStdout().contains("+");
    }

    public void setSshCommand(String sshCommand) {
        this.sshCommand = sshCommand;
    }

    class LoggingOutputHandler
    extends LineOutputHandler
    implements GitOutputHandler {
        final BuildLogger buildLogger;
        final StringBuilder stringBuilder;

        public LoggingOutputHandler(BuildLogger buildLogger) {
            this.buildLogger = buildLogger;
            this.stringBuilder = new StringBuilder();
        }

        protected void processLine(int i, String s) {
            this.buildLogger.addBuildLogEntry(s);
            this.stringBuilder.append(s);
        }

        @Override
        public String getStdout() {
            return this.stringBuilder.toString();
        }
    }

    class GitStringOutputHandler
    extends StringOutputHandler
    implements GitOutputHandler {
        GitStringOutputHandler() {
        }

        @Override
        public String getStdout() {
            return this.getOutput();
        }
    }

    static interface GitOutputHandler
    extends OutputHandler {
        public String getStdout();
    }
}

