/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorImpl;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.commit.CommitFileImpl;
import com.atlassian.bamboo.commit.CommitImpl;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.plugins.git.GitSshSessionFactory;
import com.atlassian.bamboo.plugins.git.TransportAllTrustingHttps;
import com.atlassian.bamboo.plugins.git.TweakedUsernamePasswordCredentialsProvider;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.opensymphony.xwork.TextProvider;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shaded.eclipse.jgit.diff.DiffEntry;
import org.shaded.eclipse.jgit.errors.NotSupportedException;
import org.shaded.eclipse.jgit.errors.TransportException;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.lib.PersonIdent;
import org.shaded.eclipse.jgit.lib.Ref;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.revwalk.RevCommit;
import org.shaded.eclipse.jgit.revwalk.RevWalk;
import org.shaded.eclipse.jgit.storage.file.FileRepository;
import org.shaded.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.shaded.eclipse.jgit.transport.Connection;
import org.shaded.eclipse.jgit.transport.FetchConnection;
import org.shaded.eclipse.jgit.transport.RefSpec;
import org.shaded.eclipse.jgit.transport.SshTransport;
import org.shaded.eclipse.jgit.transport.Transport;
import org.shaded.eclipse.jgit.transport.TransportHttp;
import org.shaded.eclipse.jgit.transport.URIish;
import org.shaded.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.shaded.eclipse.jgit.treewalk.TreeWalk;

public abstract class GitOperationHelper {
    private static final Logger log = Logger.getLogger(GitOperationHelper.class);
    private static final int DEFAULT_TRANSFER_TIMEOUT = new SystemProperty(false, new String[]{"atlassian.bamboo.git.timeout", "GIT_TIMEOUT"}).getValue(600);
    private static final int CHANGESET_LIMIT = new SystemProperty(false, new String[]{"atlassian.bamboo.git.changeset.limit", "GIT_CHANGESET_LIMIT"}).getValue(100);
    private static final String[] FQREF_PREFIXES = new String[]{"refs/heads/", "refs/"};
    protected final BuildLogger buildLogger;
    protected final TextProvider textProvider;

    public GitOperationHelper(@NotNull BuildLogger buildLogger, @NotNull TextProvider textProvider) {
        this.buildLogger = buildLogger;
        this.textProvider = textProvider;
    }

    protected abstract void doFetch(@NotNull Transport var1, @NotNull File var2, @NotNull GitRepository.GitRepositoryAccessData var3, RefSpec var4, boolean var5) throws RepositoryException;

    protected abstract String doCheckout(@NotNull FileRepository var1, @NotNull File var2, @NotNull String var3, @Nullable String var4, boolean var5) throws RepositoryException;

    @NotNull
    public String checkout(@Nullable File cacheDirectory, @NotNull File sourceDirectory, @NotNull String targetRevision, @Nullable String previousRevision, boolean useSubmodules) throws RepositoryException {
        this.buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.checkingOutRevision", Arrays.asList(targetRevision)));
        try {
            FileRepository localRepository = this.createLocalRepository(sourceDirectory, cacheDirectory);
            File lck = new File(localRepository.getIndexFile().getParentFile(), localRepository.getIndexFile().getName() + ".lock");
            FileUtils.deleteQuietly((File)lck);
            return this.doCheckout(localRepository, sourceDirectory, targetRevision, previousRevision, useSubmodules);
        }
        catch (IOException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.textProvider.getText("repository.git.messages.checkoutFailed", Arrays.asList(targetRevision))) + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fetch(@NotNull File sourceDirectory, @NotNull GitRepository.GitRepositoryAccessData accessData, boolean useShallow) throws RepositoryException {
        Transport transport = null;
        FileRepository localRepository = null;
        String branchDescription = "(unresolved) " + accessData.branch;
        try {
            String resolvedBranch;
            localRepository = this.createLocalRepository(sourceDirectory, null);
            transport = this.open(localRepository, accessData);
            if (StringUtils.startsWithAny((String)accessData.branch, (String[])FQREF_PREFIXES)) {
                resolvedBranch = accessData.branch;
            } else {
                FetchConnection fetchConnection = transport.openFetch();
                try {
                    resolvedBranch = GitOperationHelper.resolveRefSpec(accessData, fetchConnection).getName();
                }
                finally {
                    fetchConnection.close();
                }
            }
            branchDescription = resolvedBranch;
            this.buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.fetchingBranch", Arrays.asList(branchDescription, accessData.repositoryUrl)) + (useShallow ? " " + this.textProvider.getText("repository.git.messages.doingShallowFetch") : ""));
            RefSpec refSpec = new RefSpec().setForceUpdate(true).setSource(resolvedBranch).setDestination(resolvedBranch);
            this.doFetch(transport, sourceDirectory, accessData, refSpec, useShallow);
            if (resolvedBranch.startsWith("refs/heads/")) {
                localRepository.updateRef("HEAD").link(resolvedBranch);
            }
            String string = resolvedBranch;
            return string;
        }
        catch (IOException e) {
            String message = this.textProvider.getText("repository.git.messages.fetchingFailed", Arrays.asList(accessData.repositoryUrl, branchDescription, sourceDirectory));
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(message + " " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (localRepository != null) {
                localRepository.close();
            }
            if (transport != null) {
                transport.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getCurrentRevision(@NotNull File sourceDirectory) {
        File gitDirectory = new File(sourceDirectory, ".git");
        if (!gitDirectory.exists()) {
            return null;
        }
        Repository localRepository = null;
        try {
            localRepository = new FileRepository(new File(sourceDirectory, ".git"));
            ObjectId objId = localRepository.resolve("HEAD");
            String string = objId != null ? objId.getName() : null;
            return string;
        }
        catch (IOException e) {
            log.warn((Object)this.buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.cannotDetermineRevision", Arrays.asList(sourceDirectory)) + " " + e.getMessage()), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (localRepository != null) {
                localRepository.close();
            }
        }
    }

    @NotNull
    public String obtainLatestRevision(@NotNull GitRepository.GitRepositoryAccessData repositoryData) throws RepositoryException {
        Transport transport = null;
        Connection fetchConnection = null;
        try {
            transport = this.open(new FileRepository(""), repositoryData);
            fetchConnection = transport.openFetch();
            Ref headRef = GitOperationHelper.resolveRefSpec(repositoryData, (FetchConnection)fetchConnection);
            if (headRef == null) {
                throw new RepositoryException(this.textProvider.getText("repository.git.messages.cannotDetermineHead", Arrays.asList(repositoryData.repositoryUrl, repositoryData.branch)));
            }
            String string = headRef.getObjectId().getName();
            return string;
        }
        catch (NotSupportedException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.textProvider.getText("repository.git.messages.protocolUnsupported", Arrays.asList(repositoryData.repositoryUrl))), (Throwable)e);
        }
        catch (TransportException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.textProvider.getText("repository.git.messages.failedToCreateFileRepository")), (Throwable)e);
        }
        finally {
            if (fetchConnection != null) {
                fetchConnection.close();
            }
            if (transport != null) {
                transport.close();
            }
        }
    }

    @Nullable
    protected static Ref resolveRefSpec(GitRepository.GitRepositoryAccessData repositoryData, FetchConnection fetchConnection) {
        List<String> candidates = StringUtils.isBlank((String)repositoryData.branch) ? Arrays.asList("refs/heads/master", "HEAD") : (StringUtils.startsWithAny((String)repositoryData.branch, (String[])FQREF_PREFIXES) ? Collections.singletonList(repositoryData.branch) : Arrays.asList(repositoryData.branch, "refs/heads/" + repositoryData.branch, "refs/tags/" + repositoryData.branch));
        for (String candidate : candidates) {
            Ref headRef = fetchConnection.getRef(candidate);
            if (headRef == null) continue;
            return headRef;
        }
        return null;
    }

    protected FileRepository createLocalRepository(File workingDirectory, @Nullable File cacheDirectory) throws IOException {
        Object[] alternateObjectDirectories;
        File gitDirectory = new File(workingDirectory, ".git");
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        builder.setGitDir(gitDirectory);
        String headRef = null;
        File cacheGitDir = null;
        if (cacheDirectory != null && cacheDirectory.exists()) {
            FileRepositoryBuilder cacheRepoBuilder = (FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(cacheDirectory)).setup();
            cacheGitDir = cacheRepoBuilder.getGitDir();
            File objectsCache = cacheRepoBuilder.getObjectDirectory();
            if (objectsCache != null && objectsCache.exists()) {
                builder.addAlternateObjectDirectory(objectsCache);
                headRef = FileUtils.readFileToString((File)new File(cacheRepoBuilder.getGitDir(), "HEAD"));
            }
        }
        FileRepository localRepository = builder.build();
        if (!gitDirectory.exists()) {
            this.buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.creatingGitRepository", Arrays.asList(gitDirectory)));
            localRepository.create();
        }
        if (ArrayUtils.isNotEmpty((Object[])(alternateObjectDirectories = builder.getAlternateObjectDirectories()))) {
            ArrayList<String> alternatePaths = new ArrayList<String>(alternateObjectDirectories.length);
            for (Object alternateObjectDirectory : alternateObjectDirectories) {
                alternatePaths.add(((File)alternateObjectDirectory).getAbsolutePath());
            }
            File alternates = new File(new File(localRepository.getObjectsDirectory(), "info"), "alternates");
            FileUtils.writeLines((File)alternates, alternatePaths, (String)"\n");
        }
        if (cacheGitDir != null && cacheGitDir.isDirectory()) {
            FileUtils.copyDirectoryToDirectory((File)new File(cacheGitDir, "refs/tags/"), (File)new File(localRepository.getDirectory(), "refs/"));
            FileUtils.copyDirectoryToDirectory((File)new File(cacheGitDir, "refs/heads/"), (File)new File(localRepository.getDirectory(), "refs/"));
            File shallow = new File(cacheGitDir, "shallow");
            if (shallow.exists()) {
                FileUtils.copyFileToDirectory((File)shallow, (File)localRepository.getDirectory());
            }
        }
        if (StringUtils.startsWith(headRef, (String)"ref: ")) {
            FileUtils.writeStringToFile((File)new File(localRepository.getDirectory(), "HEAD"), headRef);
        }
        return localRepository;
    }

    BuildRepositoryChanges extractCommits(@NotNull File directory, @Nullable String previousRevision, @Nullable String targetRevision) throws RepositoryException {
        ArrayList<CommitImpl> commits = new ArrayList<CommitImpl>();
        int skippedCommits = 0;
        Repository localRepository = null;
        RevWalk revWalk = null;
        TreeWalk treeWalk = null;
        try {
            File gitDirectory = new File(directory, ".git");
            localRepository = new FileRepository(gitDirectory);
            revWalk = new RevWalk(localRepository);
            if (targetRevision != null) {
                revWalk.markStart(revWalk.parseCommit(localRepository.resolve(targetRevision)));
            }
            if (previousRevision != null) {
                revWalk.markUninteresting(revWalk.parseCommit(localRepository.resolve(previousRevision)));
            }
            treeWalk = new TreeWalk(localRepository);
            treeWalk.setRecursive(true);
            for (RevCommit jgitCommit : revWalk) {
                if (commits.size() >= CHANGESET_LIMIT) {
                    ++skippedCommits;
                    continue;
                }
                CommitImpl commit = new CommitImpl();
                commit.setComment(jgitCommit.getFullMessage());
                commit.setAuthor((Author)this.getAuthor(jgitCommit));
                commit.setDate(jgitCommit.getAuthorIdent().getWhen());
                commit.setChangeSetId(jgitCommit.getName());
                commits.add(commit);
                if (jgitCommit.getParentCount() >= 2 || localRepository.getShallows().contains(jgitCommit.getId())) continue;
                treeWalk.reset();
                int treePosition = jgitCommit.getParentCount() > 0 ? treeWalk.addTree(jgitCommit.getParent(0).getTree()) : treeWalk.addTree(new EmptyTreeIterator());
                treeWalk.addTree(jgitCommit.getTree());
                for (DiffEntry entry : DiffEntry.scan(treeWalk)) {
                    if (entry.getOldId().equals(entry.getNewId())) continue;
                    commit.addFile((CommitFile)new CommitFileImpl(jgitCommit.getId().getName(), entry.getChangeType() == DiffEntry.ChangeType.DELETE ? entry.getOldPath() : entry.getNewPath()));
                }
            }
        }
        catch (IOException e) {
            String message = this.textProvider.getText("repository.git.messages.extractingChangesetsException", Arrays.asList(directory, previousRevision, targetRevision));
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(message + " " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (treeWalk != null) {
                treeWalk.release();
            }
            if (revWalk != null) {
                revWalk.release();
            }
            if (localRepository != null) {
                localRepository.close();
            }
        }
        BuildRepositoryChangesImpl buildChanges = new BuildRepositoryChangesImpl(targetRevision, commits);
        buildChanges.setSkippedCommitsCount(skippedCommits);
        return buildChanges;
    }

    private AuthorImpl getAuthor(RevCommit commit) {
        PersonIdent gitPerson = commit.getAuthorIdent();
        if (gitPerson == null) {
            return new AuthorImpl("[unknown]");
        }
        return new AuthorImpl(String.format("%s <%s>", gitPerson.getName(), gitPerson.getEmailAddress()));
    }

    Transport open(@NotNull FileRepository localRepository, @NotNull GitRepository.GitRepositoryAccessData accessData) throws RepositoryException {
        try {
            URIish uri = new URIish(accessData.repositoryUrl);
            if ("ssh".equals(uri.getScheme()) && accessData.authenticationType == GitAuthenticationType.PASSWORD && StringUtils.isBlank((String)uri.getUser()) && StringUtils.isNotBlank((String)accessData.username)) {
                uri = uri.setUser(accessData.username);
            }
            class TransportHttpHack
            extends TransportHttp {
                TransportHttpHack(FileRepository localRepository, URIish uri) throws NotSupportedException {
                    super(localRepository, uri);
                }
            }
            Transport transport = TransportAllTrustingHttps.canHandle(uri) ? new TransportAllTrustingHttps(localRepository, uri) : ("http".equals(uri.getScheme()) ? new TransportHttpHack(localRepository, uri) : Transport.open((Repository)localRepository, uri));
            transport.setTimeout(DEFAULT_TRANSFER_TIMEOUT);
            if (transport instanceof SshTransport) {
                boolean useKey = accessData.authenticationType == GitAuthenticationType.SSH_KEYPAIR;
                String sshKey = useKey ? accessData.sshKey : null;
                String passphrase = useKey ? accessData.sshPassphrase : null;
                GitSshSessionFactory factory = new GitSshSessionFactory(sshKey, passphrase);
                ((SshTransport)transport).setSshSessionFactory(factory);
                if (passphrase != null) {
                    transport.setCredentialsProvider(new TweakedUsernamePasswordCredentialsProvider("dummy", passphrase));
                }
            }
            if (accessData.authenticationType == GitAuthenticationType.PASSWORD) {
                transport.setCredentialsProvider(new TweakedUsernamePasswordCredentialsProvider(accessData.username, accessData.password));
            }
            return transport;
        }
        catch (URISyntaxException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.textProvider.getText("repository.git.messages.invalidURI", Arrays.asList(accessData.repositoryUrl))), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.textProvider.getText("repository.git.messages.failedToOpenTransport", Arrays.asList(accessData.repositoryUrl))), (Throwable)e);
        }
    }
}

