/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.merge;

import java.io.IOException;
import org.shaded.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.lib.AnyObjectId;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.merge.Merger;
import org.shaded.eclipse.jgit.revwalk.RevTree;
import org.shaded.eclipse.jgit.treewalk.AbstractTreeIterator;

public abstract class ThreeWayMerger
extends Merger {
    private RevTree baseTree;

    protected ThreeWayMerger(Repository local) {
        super(local);
    }

    protected ThreeWayMerger(Repository local, boolean inCore) {
        this(local);
    }

    public void setBase(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.baseTree = id != null ? this.walk.parseTree(id) : null;
    }

    public boolean merge(AnyObjectId a, AnyObjectId b) throws IOException {
        return this.merge(new AnyObjectId[]{a, b});
    }

    public boolean merge(AnyObjectId[] tips) throws IOException {
        if (tips.length != 2) {
            return false;
        }
        return super.merge(tips);
    }

    protected AbstractTreeIterator mergeBase() throws IOException {
        if (this.baseTree != null) {
            return this.openTree(this.baseTree);
        }
        return this.mergeBase(0, 1);
    }
}

