/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.lib.AnyObjectId;
import org.shaded.eclipse.jgit.lib.Constants;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.lib.ProgressMonitor;
import org.shaded.eclipse.jgit.lib.Ref;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.revwalk.RevCommit;
import org.shaded.eclipse.jgit.storage.pack.PackConfig;
import org.shaded.eclipse.jgit.storage.pack.PackWriter;

public class BundleWriter {
    private final Repository db;
    private final Map<String, ObjectId> include;
    private final Set<RevCommit> assume;
    private PackConfig packConfig;

    public BundleWriter(Repository repo) {
        this.db = repo;
        this.include = new TreeMap<String, ObjectId>();
        this.assume = new HashSet<RevCommit>();
    }

    public void setPackConfig(PackConfig pc) {
        this.packConfig = pc;
    }

    public void include(String name, AnyObjectId id) {
        if (!Repository.isValidRefName(name)) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidRefName, name));
        }
        if (this.include.containsKey(name)) {
            throw new IllegalStateException(JGitText.get().duplicateRef + name);
        }
        this.include.put(name, id.toObjectId());
    }

    public void include(Ref r) {
        this.include(r.getName(), r.getObjectId());
    }

    public void assume(RevCommit c) {
        if (c != null) {
            this.assume.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBundle(ProgressMonitor monitor, OutputStream os) throws IOException {
        PackConfig pc = this.packConfig;
        if (pc == null) {
            pc = new PackConfig(this.db);
        }
        PackWriter packWriter = new PackWriter(pc, this.db.newObjectReader());
        try {
            HashSet<ObjectId> inc = new HashSet<ObjectId>();
            HashSet<ObjectId> exc = new HashSet<ObjectId>();
            inc.addAll(this.include.values());
            for (RevCommit r : this.assume) {
                exc.add(r.getId());
            }
            packWriter.setThin(exc.size() > 0);
            packWriter.preparePack(monitor, inc, exc);
            OutputStreamWriter w = new OutputStreamWriter(os, Constants.CHARSET);
            w.write("# v2 git bundle");
            ((Writer)w).write(10);
            char[] tmp = new char[40];
            for (RevCommit revCommit : this.assume) {
                ((Writer)w).write(45);
                revCommit.copyTo(tmp, w);
                if (revCommit.getRawBuffer() != null) {
                    ((Writer)w).write(32);
                    w.write(revCommit.getShortMessage());
                }
                ((Writer)w).write(10);
            }
            for (Map.Entry entry : this.include.entrySet()) {
                ((ObjectId)entry.getValue()).copyTo(tmp, w);
                ((Writer)w).write(32);
                w.write((String)entry.getKey());
                ((Writer)w).write(10);
            }
            ((Writer)w).write(10);
            ((Writer)w).flush();
            packWriter.writePack(monitor, monitor, os);
        }
        finally {
            packWriter.release();
        }
    }
}

