/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.api.GitCommand;
import org.shaded.eclipse.jgit.api.errors.InvalidRemoteException;
import org.shaded.eclipse.jgit.api.errors.JGitInternalException;
import org.shaded.eclipse.jgit.errors.NotSupportedException;
import org.shaded.eclipse.jgit.errors.TransportException;
import org.shaded.eclipse.jgit.lib.NullProgressMonitor;
import org.shaded.eclipse.jgit.lib.ProgressMonitor;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.transport.CredentialsProvider;
import org.shaded.eclipse.jgit.transport.PushResult;
import org.shaded.eclipse.jgit.transport.RefSpec;
import org.shaded.eclipse.jgit.transport.RemoteRefUpdate;
import org.shaded.eclipse.jgit.transport.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushCommand
extends GitCommand<Iterable<PushResult>> {
    private String remote = "origin";
    private List<RefSpec> refSpecs;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private String receivePack = "git-receive-pack";
    private boolean dryRun;
    private boolean force;
    private boolean thin = false;
    private int timeout;
    private CredentialsProvider credentialsProvider;

    protected PushCommand(Repository repo) {
        super(repo);
        this.refSpecs = new ArrayList<RefSpec>(3);
    }

    @Override
    public Iterable<PushResult> call() throws JGitInternalException, InvalidRemoteException {
        this.checkCallable();
        ArrayList<PushResult> pushResults = new ArrayList<PushResult>(3);
        try {
            if (this.force) {
                ArrayList<RefSpec> orig = new ArrayList<RefSpec>(this.refSpecs);
                this.refSpecs.clear();
                for (RefSpec spec : orig) {
                    this.refSpecs.add(spec.setForceUpdate(true));
                }
            }
            List<Transport> transports = Transport.openAll(this.repo, this.remote, Transport.Operation.PUSH);
            for (Transport transport : transports) {
                if (0 <= this.timeout) {
                    transport.setTimeout(this.timeout);
                }
                transport.setPushThin(this.thin);
                if (this.receivePack != null) {
                    transport.setOptionReceivePack(this.receivePack);
                }
                transport.setDryRun(this.dryRun);
                if (this.credentialsProvider != null) {
                    transport.setCredentialsProvider(this.credentialsProvider);
                }
                Collection<RemoteRefUpdate> toPush = transport.findRemoteRefUpdatesFor(this.refSpecs);
                try {
                    PushResult result = transport.push(this.monitor, toPush);
                    pushResults.add(result);
                }
                catch (TransportException e) {
                    throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, e);
                }
                finally {
                    transport.close();
                }
            }
        }
        catch (URISyntaxException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote));
        }
        catch (NotSupportedException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, e);
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, e);
        }
        return pushResults;
    }

    public PushCommand setRemote(String remote) {
        this.checkCallable();
        this.remote = remote;
        return this;
    }

    public String getRemote() {
        return this.remote;
    }

    public PushCommand setReceivePack(String receivePack) {
        this.checkCallable();
        this.receivePack = receivePack;
        return this;
    }

    public String getReceivePack() {
        return this.receivePack;
    }

    public PushCommand setTimeout(int timeout) {
        this.checkCallable();
        this.timeout = timeout;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public PushCommand setProgressMonitor(ProgressMonitor monitor) {
        this.checkCallable();
        this.monitor = monitor;
        return this;
    }

    public List<RefSpec> getRefSpecs() {
        return this.refSpecs;
    }

    public PushCommand setRefSpecs(RefSpec ... specs) {
        this.checkCallable();
        this.refSpecs.clear();
        Collections.addAll(this.refSpecs, specs);
        return this;
    }

    public PushCommand setRefSpecs(List<RefSpec> specs) {
        this.checkCallable();
        this.refSpecs.clear();
        this.refSpecs.addAll(specs);
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public PushCommand setDryRun(boolean dryRun) {
        this.checkCallable();
        this.dryRun = dryRun;
        return this;
    }

    public boolean isThin() {
        return this.thin;
    }

    public PushCommand setThin(boolean thin) {
        this.checkCallable();
        this.thin = thin;
        return this;
    }

    public boolean isForce() {
        return this.force;
    }

    public PushCommand setForce(boolean force) {
        this.checkCallable();
        this.force = force;
        return this;
    }

    public PushCommand setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.checkCallable();
        this.credentialsProvider = credentialsProvider;
        return this;
    }
}

