/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.api;

import org.shaded.eclipse.jgit.api.AddCommand;
import org.shaded.eclipse.jgit.api.CheckoutCommand;
import org.shaded.eclipse.jgit.api.CherryPickCommand;
import org.shaded.eclipse.jgit.api.CloneCommand;
import org.shaded.eclipse.jgit.api.CommitCommand;
import org.shaded.eclipse.jgit.api.CreateBranchCommand;
import org.shaded.eclipse.jgit.api.DeleteBranchCommand;
import org.shaded.eclipse.jgit.api.FetchCommand;
import org.shaded.eclipse.jgit.api.InitCommand;
import org.shaded.eclipse.jgit.api.ListBranchCommand;
import org.shaded.eclipse.jgit.api.LogCommand;
import org.shaded.eclipse.jgit.api.MergeCommand;
import org.shaded.eclipse.jgit.api.PullCommand;
import org.shaded.eclipse.jgit.api.PushCommand;
import org.shaded.eclipse.jgit.api.RebaseCommand;
import org.shaded.eclipse.jgit.api.RenameBranchCommand;
import org.shaded.eclipse.jgit.api.RevertCommand;
import org.shaded.eclipse.jgit.api.RmCommand;
import org.shaded.eclipse.jgit.api.TagCommand;
import org.shaded.eclipse.jgit.lib.Repository;

public class Git {
    private final Repository repo;

    public static CloneCommand cloneRepository() {
        return new CloneCommand();
    }

    public static InitCommand init() {
        return new InitCommand();
    }

    public Git(Repository repo) {
        if (repo == null) {
            throw new NullPointerException();
        }
        this.repo = repo;
    }

    public CommitCommand commit() {
        return new CommitCommand(this.repo);
    }

    public LogCommand log() {
        return new LogCommand(this.repo);
    }

    public MergeCommand merge() {
        return new MergeCommand(this.repo);
    }

    public PullCommand pull() {
        return new PullCommand(this.repo);
    }

    public CreateBranchCommand branchCreate() {
        return new CreateBranchCommand(this.repo);
    }

    public DeleteBranchCommand branchDelete() {
        return new DeleteBranchCommand(this.repo);
    }

    public ListBranchCommand branchList() {
        return new ListBranchCommand(this.repo);
    }

    public RenameBranchCommand branchRename() {
        return new RenameBranchCommand(this.repo);
    }

    public AddCommand add() {
        return new AddCommand(this.repo);
    }

    public TagCommand tag() {
        return new TagCommand(this.repo);
    }

    public FetchCommand fetch() {
        return new FetchCommand(this.repo);
    }

    public PushCommand push() {
        return new PushCommand(this.repo);
    }

    public CherryPickCommand cherryPick() {
        return new CherryPickCommand(this.repo);
    }

    public RevertCommand revert() {
        return new RevertCommand(this.repo);
    }

    public RebaseCommand rebase() {
        return new RebaseCommand(this.repo);
    }

    public RmCommand rm() {
        return new RmCommand(this.repo);
    }

    public CheckoutCommand checkout() {
        return new CheckoutCommand(this.repo);
    }

    public Repository getRepository() {
        return this.repo;
    }
}

