/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import org.shaded.eclipse.jgit.api.FetchCommand;
import org.shaded.eclipse.jgit.api.Git;
import org.shaded.eclipse.jgit.api.InitCommand;
import org.shaded.eclipse.jgit.api.errors.InvalidRemoteException;
import org.shaded.eclipse.jgit.api.errors.JGitInternalException;
import org.shaded.eclipse.jgit.dircache.DirCache;
import org.shaded.eclipse.jgit.dircache.DirCacheCheckout;
import org.shaded.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.lib.NullProgressMonitor;
import org.shaded.eclipse.jgit.lib.ProgressMonitor;
import org.shaded.eclipse.jgit.lib.Ref;
import org.shaded.eclipse.jgit.lib.RefUpdate;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.revwalk.RevCommit;
import org.shaded.eclipse.jgit.revwalk.RevWalk;
import org.shaded.eclipse.jgit.transport.CredentialsProvider;
import org.shaded.eclipse.jgit.transport.FetchResult;
import org.shaded.eclipse.jgit.transport.RefSpec;
import org.shaded.eclipse.jgit.transport.RemoteConfig;
import org.shaded.eclipse.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneCommand
implements Callable<Git> {
    private String uri;
    private File directory;
    private boolean bare;
    private String remote = "origin";
    private String branch = "HEAD";
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private CredentialsProvider credentialsProvider;

    @Override
    public Git call() throws JGitInternalException {
        try {
            URIish u = new URIish(this.uri);
            Repository repository = this.init(u);
            FetchResult result = this.fetch(repository, u);
            this.checkout(repository, result);
            return new Git(repository);
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
        catch (InvalidRemoteException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    private Repository init(URIish u) {
        InitCommand command = Git.init();
        command.setBare(this.bare);
        if (this.directory == null) {
            this.directory = new File(u.getHumanishName(), ".git");
        }
        command.setDirectory(this.directory);
        return command.call().getRepository();
    }

    private FetchResult fetch(Repository repo, URIish u) throws URISyntaxException, JGitInternalException, InvalidRemoteException, IOException {
        RemoteConfig config = new RemoteConfig(repo.getConfig(), this.remote);
        config.addURI(u);
        String dst = "refs/remotes/" + config.getName();
        RefSpec refSpec = new RefSpec();
        refSpec = refSpec.setForceUpdate(true);
        refSpec = refSpec.setSourceDestination("refs/heads/*", dst + "/*");
        config.addFetchRefSpec(refSpec);
        config.update(repo.getConfig());
        repo.getConfig().save();
        FetchCommand command = new FetchCommand(repo);
        command.setRemote(this.remote);
        command.setProgressMonitor(this.monitor);
        if (this.credentialsProvider != null) {
            command.setCredentialsProvider(this.credentialsProvider);
        }
        return command.call();
    }

    private void checkout(Repository repo, FetchResult result) throws JGitInternalException, MissingObjectException, IncorrectObjectTypeException, IOException {
        Object head;
        if (this.branch.startsWith("refs/heads/")) {
            head = repo.updateRef("HEAD");
            ((RefUpdate)head).disableRefLog();
            ((RefUpdate)head).link(this.branch);
        }
        if ((head = result.getAdvertisedRef(this.branch)) == null || head.getObjectId() == null) {
            return;
        }
        RevCommit commit = this.parseCommit(repo, (Ref)head);
        boolean detached = !head.getName().startsWith("refs/heads/");
        RefUpdate u = repo.updateRef("HEAD", detached);
        u.setNewObjectId(commit.getId());
        u.forceUpdate();
        DirCache dc = repo.lockDirCache();
        DirCacheCheckout co = new DirCacheCheckout(repo, dc, commit.getTree());
        co.checkout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RevCommit parseCommit(Repository repo, Ref ref) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit commit;
        RevWalk rw = new RevWalk(repo);
        try {
            commit = rw.parseCommit(ref.getObjectId());
        }
        finally {
            rw.release();
        }
        return commit;
    }

    public CloneCommand setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public CloneCommand setDirectory(File directory) {
        this.directory = directory;
        return this;
    }

    public CloneCommand setBare(boolean bare) {
        this.bare = bare;
        return this;
    }

    public CloneCommand setRemote(String remote) {
        this.remote = remote;
        return this;
    }

    public CloneCommand setBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public CloneCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public CloneCommand setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }
}

