/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.util;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import org.shaded.eclipse.jgit.util.FS;
import org.shaded.eclipse.jgit.util.FS_Win32;

class FS_Win32_Cygwin
extends FS_Win32 {
    private static String cygpath;

    FS_Win32_Cygwin() {
    }

    static boolean detect() {
        String path = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.library.path");
            }
        });
        if (path == null) {
            return false;
        }
        File found = FS.searchPath(path, "cygpath.exe");
        if (found != null) {
            cygpath = found.getPath();
        }
        return cygpath != null;
    }

    public File resolve(File dir, String pn) {
        String w = FS_Win32_Cygwin.readPipe(dir, new String[]{cygpath, "--windows", "--absolute", pn}, "UTF-8");
        if (w != null) {
            return new File(w);
        }
        return super.resolve(dir, pn);
    }

    protected File userHomeImpl() {
        String home = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv("HOME");
            }
        });
        if (home == null || home.length() == 0) {
            return super.userHomeImpl();
        }
        return this.resolve(new File("."), home);
    }

    public ProcessBuilder runInShell(String cmd, String[] args) {
        ArrayList<String> argv = new ArrayList<String>(4 + args.length);
        argv.add("sh.exe");
        argv.add("-c");
        argv.add(cmd + " \"$@\"");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }
}

