/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.errors.NotSupportedException;
import org.shaded.eclipse.jgit.errors.TransportException;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.transport.BundleFetchConnection;
import org.shaded.eclipse.jgit.transport.FetchConnection;
import org.shaded.eclipse.jgit.transport.PushConnection;
import org.shaded.eclipse.jgit.transport.Transport;
import org.shaded.eclipse.jgit.transport.TransportBundle;
import org.shaded.eclipse.jgit.transport.URIish;

public class TransportBundleStream
extends Transport
implements TransportBundle {
    private InputStream src;

    public TransportBundleStream(Repository db, URIish uri, InputStream in) {
        super(db, uri);
        this.src = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FetchConnection openFetch() throws TransportException {
        if (this.src == null) {
            throw new TransportException(this.uri, JGitText.get().onlyOneFetchSupported);
        }
        try {
            BundleFetchConnection bundleFetchConnection = new BundleFetchConnection(this, this.src);
            return bundleFetchConnection;
        }
        finally {
            this.src = null;
        }
    }

    public PushConnection openPush() throws NotSupportedException {
        throw new NotSupportedException(JGitText.get().pushIsNotSupportedForBundleTransport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.src != null) {
            try {
                this.src.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.src = null;
            }
        }
    }
}

