/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.api.GitCommand;
import org.shaded.eclipse.jgit.api.errors.DetachedHeadException;
import org.shaded.eclipse.jgit.api.errors.InvalidRefNameException;
import org.shaded.eclipse.jgit.api.errors.JGitInternalException;
import org.shaded.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.shaded.eclipse.jgit.api.errors.RefNotFoundException;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.lib.Ref;
import org.shaded.eclipse.jgit.lib.RefRename;
import org.shaded.eclipse.jgit.lib.RefUpdate;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.lib.StoredConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameBranchCommand
extends GitCommand<Ref> {
    private String oldName;
    private String newName;

    protected RenameBranchCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Ref call() throws RefNotFoundException, InvalidRefNameException, RefAlreadyExistsException, DetachedHeadException {
        this.checkCallable();
        if (this.newName == null) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, "<null>"));
        }
        try {
            boolean ok;
            String fullOldName;
            if (this.repo.getRef(this.newName) != null) {
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().refAlreadyExists, this.newName));
            }
            if (this.oldName != null) {
                Ref ref = this.repo.getRef(this.oldName);
                if (ref == null) {
                    throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.oldName));
                }
                if (ref.getName().startsWith("refs/tags/")) {
                    throw new RefNotFoundException(MessageFormat.format(JGitText.get().renameBranchFailedBecauseTag, this.oldName));
                }
                fullOldName = ref.getName();
            } else {
                fullOldName = this.repo.getFullBranch();
                if (ObjectId.isId(fullOldName)) {
                    throw new DetachedHeadException();
                }
            }
            String fullNewName = fullOldName.startsWith("refs/remotes/") ? "refs/remotes/" + this.newName : "refs/heads/" + this.newName;
            if (!Repository.isValidRefName(fullNewName)) {
                throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, fullNewName));
            }
            RefRename rename = this.repo.renameRef(fullOldName, fullNewName);
            RefUpdate.Result renameResult = rename.rename();
            this.setCallable(false);
            boolean bl = ok = RefUpdate.Result.RENAMED == renameResult;
            if (ok) {
                if (fullNewName.startsWith("refs/heads/")) {
                    String oldMerge;
                    String shortOldName = fullOldName.substring("refs/heads/".length());
                    StoredConfig repoConfig = this.repo.getConfig();
                    String oldRemote = repoConfig.getString("branch", shortOldName, "remote");
                    if (oldRemote != null) {
                        repoConfig.setString("branch", this.newName, "remote", oldRemote);
                    }
                    if ((oldMerge = repoConfig.getString("branch", shortOldName, "merge")) != null) {
                        repoConfig.setString("branch", this.newName, "merge", oldMerge);
                    }
                    repoConfig.unsetSection("branch", shortOldName);
                    repoConfig.save();
                }
            } else {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().renameBranchUnexpectedResult, renameResult.name()));
            }
            Ref resultRef = this.repo.getRef(this.newName);
            if (resultRef == null) {
                throw new JGitInternalException(JGitText.get().renameBranchFailedUnknownReason);
            }
            return resultRef;
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
    }

    public RenameBranchCommand setNewName(String newName) {
        this.checkCallable();
        this.newName = newName;
        return this;
    }

    public RenameBranchCommand setOldName(String oldName) {
        this.checkCallable();
        this.oldName = oldName;
        return this;
    }
}

