/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.storage.file.LocalObjectRepresentation;
import org.shaded.eclipse.jgit.storage.file.ObjectDirectory;
import org.shaded.eclipse.jgit.storage.file.PackFile;
import org.shaded.eclipse.jgit.storage.file.WindowCursor;
import org.shaded.eclipse.jgit.storage.pack.CachedPack;
import org.shaded.eclipse.jgit.storage.pack.ObjectToPack;
import org.shaded.eclipse.jgit.storage.pack.PackOutputStream;
import org.shaded.eclipse.jgit.storage.pack.StoredObjectRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalCachedPack
extends CachedPack {
    private final ObjectDirectory odb;
    private final Set<ObjectId> tips;
    private final String[] packNames;
    private PackFile[] packs;

    LocalCachedPack(ObjectDirectory odb, Set<ObjectId> tips, List<String> packNames) {
        this.odb = odb;
        this.tips = tips.size() == 1 ? Collections.singleton(tips.iterator().next()) : Collections.unmodifiableSet(tips);
        this.packNames = packNames.toArray(new String[packNames.size()]);
    }

    @Override
    public Set<ObjectId> getTips() {
        return this.tips;
    }

    @Override
    public long getObjectCount() throws IOException {
        long cnt = 0L;
        for (PackFile pack : this.getPacks()) {
            cnt += pack.getObjectCount();
        }
        return cnt;
    }

    void copyAsIs(PackOutputStream out, boolean validate, WindowCursor wc) throws IOException {
        for (PackFile pack : this.getPacks()) {
            pack.copyPackAsIs(out, validate, wc);
        }
    }

    @Override
    public boolean hasObject(ObjectToPack obj, StoredObjectRepresentation rep) {
        try {
            LocalObjectRepresentation local = (LocalObjectRepresentation)rep;
            for (PackFile pack : this.getPacks()) {
                if (local.pack != pack) continue;
                return true;
            }
            return false;
        }
        catch (FileNotFoundException packGone) {
            return false;
        }
    }

    private PackFile[] getPacks() throws FileNotFoundException {
        if (this.packs == null) {
            PackFile[] p = new PackFile[this.packNames.length];
            for (int i = 0; i < this.packNames.length; ++i) {
                p[i] = this.getPackFile(this.packNames[i]);
            }
            this.packs = p;
        }
        return this.packs;
    }

    private PackFile getPackFile(String packName) throws FileNotFoundException {
        for (PackFile pack : this.odb.getPacks()) {
            if (!packName.equals(pack.getPackName())) continue;
            return pack;
        }
        throw new FileNotFoundException(this.getPackFilePath(packName));
    }

    private String getPackFilePath(String packName) {
        File packDir = new File(this.odb.getDirectory(), "pack");
        return new File(packDir, "pack-" + packName + ".pack").getPath();
    }
}

