/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plugins.git.GitCacheDirectoryOperation;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitCacheDirectory {
    static final String GIT_REPOSITORY_CACHE_DIRECTORY = "_git-repositories-cache";
    static final Function<File, ManagedLock> cacheLockFactory = ManagedLocks.weakManagedLockFactory();
    private static final Logger log = Logger.getLogger(GitCacheDirectory.class);

    @NotNull
    static File getCacheDirectory(@NotNull File workingDirectory, @NotNull GitRepository.GitRepositoryAccessData repositoryData) {
        String repositorySha = GitCacheDirectory.calculateAggregateSha(repositoryData.repositoryUrl, repositoryData.username);
        File cacheDirectory = new File(workingDirectory, GIT_REPOSITORY_CACHE_DIRECTORY);
        return new File(cacheDirectory, repositorySha);
    }

    static String calculateAggregateSha(String ... params) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (String param : params) {
            if (param != null) {
                try {
                    baos.write(param.getBytes("UTF-8"));
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot happen: Error writing string to byte array", e);
                }
            }
            baos.write(0);
        }
        return DigestUtils.shaHex((byte[])baos.toByteArray());
    }

    public static <T> T callOnCacheWithLock(@NotNull GitRepository gitRepository, @NotNull GitCacheDirectoryOperation<T> operation) throws Exception {
        File cache = GitCacheDirectory.getCacheDirectory(gitRepository.getWorkingDirectory(), gitRepository.accessData);
        operation.setCacheDirectory(cache);
        return (T)((ManagedLock)cacheLockFactory.get((Object)cache)).withLock(operation);
    }
}

