/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BasePackFetchConnection;
import org.eclipse.jgit.transport.BasePackPushConnection;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.QuotedString;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.io.MessageWriter;
import org.eclipse.jgit.util.io.StreamCopyThread;

public class TransportGitSsh
extends SshTransport
implements PackTransport {
    static boolean canHandle(URIish uri) {
        if (!uri.isRemote()) {
            return false;
        }
        String scheme = uri.getScheme();
        if ("ssh".equals(scheme)) {
            return true;
        }
        if ("ssh+git".equals(scheme)) {
            return true;
        }
        if ("git+ssh".equals(scheme)) {
            return true;
        }
        return scheme == null && uri.getHost() != null && uri.getPath() != null;
    }

    TransportGitSsh(Repository local, URIish uri) {
        super(local, uri);
    }

    public FetchConnection openFetch() throws TransportException {
        return new SshFetchConnection(this.newConnection());
    }

    public PushConnection openPush() throws TransportException {
        return new SshPushConnection(this.newConnection());
    }

    private Connection newConnection() {
        if (TransportGitSsh.useExtConnection()) {
            return new ExtConnection();
        }
        return new JschConnection();
    }

    private static void sqMinimal(StringBuilder cmd, String val) {
        if (val.matches("^[a-zA-Z0-9._/-]*$")) {
            cmd.append(val);
        } else {
            TransportGitSsh.sq(cmd, val);
        }
    }

    private static void sqAlways(StringBuilder cmd, String val) {
        TransportGitSsh.sq(cmd, val);
    }

    private static void sq(StringBuilder cmd, String val) {
        if (val.length() > 0) {
            cmd.append(QuotedString.BOURNE.quote(val));
        }
    }

    String commandFor(String exe) {
        String path = this.uri.getPath();
        if (this.uri.getScheme() != null && this.uri.getPath().startsWith("/~")) {
            path = this.uri.getPath().substring(1);
        }
        StringBuilder cmd = new StringBuilder();
        int gitspace = exe.indexOf("git ");
        if (gitspace >= 0) {
            TransportGitSsh.sqMinimal(cmd, exe.substring(0, gitspace + 3));
            cmd.append(' ');
            TransportGitSsh.sqMinimal(cmd, exe.substring(gitspace + 4));
        } else {
            TransportGitSsh.sqMinimal(cmd, exe);
        }
        cmd.append(' ');
        TransportGitSsh.sqAlways(cmd, path);
        return cmd.toString();
    }

    void checkExecFailure(int status, String exe, String why) throws TransportException {
        if (status == 127) {
            IOException cause = null;
            if (why != null && why.length() > 0) {
                cause = new IOException(why);
            }
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().cannotExecute, this.commandFor(exe)), cause);
        }
    }

    NoRemoteRepositoryException cleanNotFound(NoRemoteRepositoryException nf, String why) {
        if (why == null || why.length() == 0) {
            return nf;
        }
        String path = this.uri.getPath();
        if (this.uri.getScheme() != null && this.uri.getPath().startsWith("/~")) {
            path = this.uri.getPath().substring(1);
        }
        StringBuilder pfx = new StringBuilder();
        pfx.append("fatal: ");
        TransportGitSsh.sqAlways(pfx, path);
        pfx.append(": ");
        if (why.startsWith(pfx.toString())) {
            why = why.substring(pfx.length());
        }
        return new NoRemoteRepositoryException(this.uri, why);
    }

    private static boolean useExtConnection() {
        return SystemReader.getInstance().getenv("GIT_SSH") != null;
    }

    class SshPushConnection
    extends BasePackPushConnection {
        private Connection conn;
        private StreamCopyThread errorThread;

        SshPushConnection(Connection conn) throws TransportException {
            super(TransportGitSsh.this);
            this.conn = conn;
            try {
                MessageWriter msg = new MessageWriter();
                this.setMessageWriter(msg);
                conn.exec(TransportGitSsh.this.getOptionReceivePack());
                InputStream rpErr = conn.getErrorStream();
                this.errorThread = new StreamCopyThread(rpErr, msg.getRawStream());
                this.errorThread.start();
                this.init(conn.getInputStream(), conn.getOutputStream());
                conn.connect();
            }
            catch (TransportException err) {
                this.close();
                throw err;
            }
            catch (IOException err) {
                this.close();
                throw new TransportException(this.uri, JGitText.get().remoteHungUpUnexpectedly, err);
            }
            try {
                this.readAdvertisedRefs();
            }
            catch (NoRemoteRepositoryException notFound) {
                String msgs = this.getMessages();
                TransportGitSsh.this.checkExecFailure(conn.getExitStatus(), TransportGitSsh.this.getOptionReceivePack(), msgs);
                throw TransportGitSsh.this.cleanNotFound(notFound, msgs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.endOut();
            if (this.errorThread != null) {
                try {
                    try {
                        this.errorThread.halt();
                    }
                    catch (InterruptedException interruptedException) {
                        Object var3_2 = null;
                        this.errorThread = null;
                    }
                    Object var3_1 = null;
                    this.errorThread = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.errorThread = null;
                    throw throwable;
                }
            }
            super.close();
            this.conn.close();
        }
    }

    class SshFetchConnection
    extends BasePackFetchConnection {
        private Connection conn;
        private StreamCopyThread errorThread;

        SshFetchConnection(Connection conn) throws TransportException {
            super(TransportGitSsh.this);
            this.conn = conn;
            try {
                MessageWriter msg = new MessageWriter();
                this.setMessageWriter(msg);
                conn.exec(TransportGitSsh.this.getOptionUploadPack());
                InputStream upErr = conn.getErrorStream();
                this.errorThread = new StreamCopyThread(upErr, msg.getRawStream());
                this.errorThread.start();
                this.init(conn.getInputStream(), conn.getOutputStream());
                conn.connect();
            }
            catch (TransportException err) {
                this.close();
                throw err;
            }
            catch (IOException err) {
                this.close();
                throw new TransportException(this.uri, JGitText.get().remoteHungUpUnexpectedly, err);
            }
            try {
                this.readAdvertisedRefs();
            }
            catch (NoRemoteRepositoryException notFound) {
                String msgs = this.getMessages();
                TransportGitSsh.this.checkExecFailure(conn.getExitStatus(), TransportGitSsh.this.getOptionUploadPack(), msgs);
                throw TransportGitSsh.this.cleanNotFound(notFound, msgs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.endOut();
            if (this.errorThread != null) {
                try {
                    try {
                        this.errorThread.halt();
                    }
                    catch (InterruptedException interruptedException) {
                        Object var3_2 = null;
                        this.errorThread = null;
                    }
                    Object var3_1 = null;
                    this.errorThread = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.errorThread = null;
                    throw throwable;
                }
            }
            super.close();
            this.conn.close();
        }
    }

    private class ExtConnection
    extends Connection {
        private Process proc;
        private int exitStatus;

        private ExtConnection() {
        }

        void exec(String commandName) throws TransportException {
            String ssh = SystemReader.getInstance().getenv("GIT_SSH");
            boolean putty = ssh.toLowerCase().contains("plink");
            ArrayList<String> args = new ArrayList<String>();
            args.add(ssh);
            if (putty && !ssh.toLowerCase().contains("tortoiseplink")) {
                args.add("-batch");
            }
            if (0 < TransportGitSsh.this.getURI().getPort()) {
                args.add(putty ? "-P" : "-p");
                args.add(String.valueOf(TransportGitSsh.this.getURI().getPort()));
            }
            if (TransportGitSsh.this.getURI().getUser() != null) {
                args.add(TransportGitSsh.this.getURI().getUser() + "@" + TransportGitSsh.this.getURI().getHost());
            } else {
                args.add(TransportGitSsh.this.getURI().getHost());
            }
            args.add(TransportGitSsh.this.commandFor(commandName));
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(args);
            if (TransportGitSsh.this.local.getDirectory() != null) {
                pb.environment().put("GIT_DIR", TransportGitSsh.this.local.getDirectory().getPath());
            }
            try {
                this.proc = pb.start();
            }
            catch (IOException err) {
                throw new TransportException(TransportGitSsh.this.uri, err.getMessage(), err);
            }
        }

        void connect() throws TransportException {
        }

        InputStream getInputStream() throws IOException {
            return this.proc.getInputStream();
        }

        OutputStream getOutputStream() throws IOException {
            return this.proc.getOutputStream();
        }

        InputStream getErrorStream() throws IOException {
            return this.proc.getErrorStream();
        }

        int getExitStatus() {
            return this.exitStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            if (this.proc != null) {
                try {
                    try {
                        this.exitStatus = this.proc.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    Object var3_2 = null;
                    this.proc = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.proc = null;
                    throw throwable;
                }
            }
        }
    }

    private class JschConnection
    extends Connection {
        private ChannelExec channel;
        private int exitStatus;

        private JschConnection() {
        }

        void exec(String commandName) throws TransportException {
            TransportGitSsh.this.initSession();
            try {
                this.channel = (ChannelExec)TransportGitSsh.this.sock.openChannel("exec");
                this.channel.setCommand(TransportGitSsh.this.commandFor(commandName));
            }
            catch (JSchException je) {
                throw new TransportException(TransportGitSsh.this.uri, je.getMessage(), je);
            }
        }

        void connect() throws TransportException {
            try {
                this.channel.connect(TransportGitSsh.this.getTimeout() > 0 ? TransportGitSsh.this.getTimeout() * 1000 : 0);
                if (!this.channel.isConnected()) {
                    throw new TransportException(TransportGitSsh.this.uri, "connection failed");
                }
            }
            catch (JSchException e) {
                throw new TransportException(TransportGitSsh.this.uri, e.getMessage(), e);
            }
        }

        InputStream getInputStream() throws IOException {
            return this.channel.getInputStream();
        }

        OutputStream getOutputStream() throws IOException {
            OutputStream out = this.channel.getOutputStream();
            if (TransportGitSsh.this.getTimeout() <= 0) {
                return out;
            }
            PipedInputStream pipeIn = new PipedInputStream();
            final StreamCopyThread copier = new StreamCopyThread(pipeIn, out);
            PipedOutputStream pipeOut = new PipedOutputStream(pipeIn){

                public void flush() throws IOException {
                    super.flush();
                    copier.flush();
                }

                public void close() throws IOException {
                    super.close();
                    try {
                        copier.join(TransportGitSsh.this.getTimeout() * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            copier.start();
            return pipeOut;
        }

        InputStream getErrorStream() throws IOException {
            return this.channel.getErrStream();
        }

        int getExitStatus() {
            return this.exitStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            if (this.channel != null) {
                try {
                    this.exitStatus = this.channel.getExitStatus();
                    if (this.channel.isConnected()) {
                        this.channel.disconnect();
                    }
                    Object var2_1 = null;
                    this.channel = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.channel = null;
                    throw throwable;
                }
            }
        }
    }

    private abstract class Connection {
        private Connection() {
        }

        abstract void exec(String var1) throws TransportException;

        abstract void connect() throws TransportException;

        abstract InputStream getInputStream() throws IOException;

        abstract OutputStream getOutputStream() throws IOException;

        abstract InputStream getErrorStream() throws IOException;

        abstract int getExitStatus();

        abstract void close();
    }
}

