[#-- @ftlvariable name="" type="com.atlassian.bamboo.clover.build.coverage.ViewCloverCoverageSummary" --]
[#-- @ftlvariable name="action" type="com.atlassian.bamboo.clover.build.coverage.ViewCloverCoverageSummary" --]
[#-- @ftlvariable name="numberUtils" type="com.atlassian.bamboo.util.NumberUtils" --]
[#-- @ftlvariable name="resultsSummary" type="com.atlassian.bamboo.chains.ChainResultsSummary" --]

[#--
draws nn% label and a bar; two sizes are available: large and medium
it can also draw "not available" message

@param coverageNumber 0-100 or empty string
@param barSize large or medium
--]
[#macro renderCoverageBarWithLabel coverageNumber barSize]
    <div class="tableRow">
        <div class="tableCellMiddleAlign">
            <div class="[#if barSize == "large"]cloverSuccessRate[#else]cloverCoverageSmall[/#if]">
                [#if coverageNumber?has_content]
                    ${coverageNumber?round}%
                [#else]
                    &#160;
                [/#if]
            </div>
        </div>
        <div class="tableCellMiddleAlign">
            [#if !coverageNumber?has_content]
                <span title="[@s.text name='clover.plan.summary.reports.notAvailable.tooltip'/]"
                      class="barNotAvailableLabel">
                    [@s.text name='clover.plan.summary.reports.notAvailable'/]
                </span>
            [#else]
                [#if barSize=="large"]
                    [#assign barClass = "barLargeSize"]
                    [#assign barUnit = 5]
                    [#assign barHeight = 20]
                [#else]
                    [#assign barClass="barMediumSize"]
                    [#assign barUnit = 2.5]
                    [#assign barHeight = 10]
                [/#if]
                <div title="${100 - coverageNumber}% Not Covered" class="barNegative ${barClass}">
                    <div title="${coverageNumber}% Covered" class="barPositive"
                         style="width:${coverageNumber * barUnit}px; height:${barHeight}px"></div>
                </div>
            [/#if]
        </div>
    </div>
[/#macro]

<html>
<head>
    [@ui.header pageKey='clover.plan.summary.title' object=immutablePlan.name title=true /]
    <meta name="tab" content="clover"/>
</head>

<body>

[@ui.header pageKey='clover.plan.summary.title' /]

[#if reportLinker??]
    [#-- make reportLinker the local variable to avoid calling the getter many times --]
    [#assign reportLinker = reportLinker]
    [#assign latestBuild = reportLinker.buildResultsSummary /]

    <div>
        [@s.text name='clover.plan.summary.build.information'/]
        <a href="${req.contextPath}/browse/${latestBuild.planResultKey}">#${latestBuild.buildNumber}</a>
        (${latestBuild.buildCompletedDate?datetime?string("hh:mm a, EEE, d MMM yyyy")})
    </div>

    [#if (latestBuild.customBuildData.CLOVER_BUILD_COVERAGE)?has_content]
        [#assign coverageNumber = numberUtils.unlocalizedStringToDouble(latestBuild.customBuildData.CLOVER_BUILD_COVERAGE) /]
        <h2>[@s.text name='clover.plan.summary.aggregated.header'/]</h2>
        [@renderCoverageBarWithLabel coverageNumber=coverageNumber barSize="large"/]
    [/#if]

    <h2>[@s.text name='clover.plan.summary.reports.header'/]</h2>

    <table class="aui">
        <thead>
            <tr>
                <th>[@s.text name='clover.plan.summary.reports.jobName'/]</th>
                <th>[@s.text name='clover.plan.summary.reports.reportName'/]</th>
                <th>[@s.text name='clover.plan.summary.reports.coverage'/]</th>
            </tr>
        </thead>
        <tbody>
            [#-- iterate over all stages and jobs in a build --]
            [#list latestBuild.getStageResults() as stageResult]
                [#list stageResult.getSortedBuildResults() as resultsSummary]

                    [#-- first: list all clover html reports from each job (0..N artifacts per job) --]
                    [#assign htmlReportCountInJob = 0 /]

                    [#list resultsSummary.getProducedArtifactLinks() as artifactLink]
                        [#if reportLinker.isCloverReport(artifactLink.getArtifact())]
                            [#assign htmlReportCountInJob = htmlReportCountInJob + 1 /]
                            <tr>
                                <td>
                                    <a href="${req.contextPath}/browse/${artifactLink.producerJobResult.planResultKey}" title="${artifactLink.producerJobResult.planResultKey.key}">
                                        ${action.getJobName(artifactLink.producerJobResult.planKey)}
                                    </a>
                                </td>
                                <td>
                                    [#-- viewCloverResult.action?buildKey=PRJ-PLAN-JOB&buildNumber=123 --]
                                    <a href="${req.contextPath}/build/result/viewCloverResult.action?buildKey=${artifactLink.producerJobResult.planKey}&amp;buildNumber=${latestBuild.buildNumber}">
                                        ${artifactLink.label}
                                    </a>
                                    <span class="aui-lozenge aui-lozenge-subtle">html</span>
                                </td>
                                <td>
                                    [#if (artifactLink.producerJobResult.customBuildData.CLOVER_BUILD_COVERAGE)?has_content]
                                        [#assign coverageNumber = numberUtils.unlocalizedStringToDouble(artifactLink.producerJobResult.customBuildData.CLOVER_BUILD_COVERAGE) /]
                                    [#else]
                                        [#assign coverageNumber = ""/]
                                    [/#if]
                                    [@renderCoverageBarWithLabel coverageNumber=coverageNumber barSize="medium"/]
                                </td>
                            </tr>
                        [/#if]
                    [/#list]

                    [#-- second: no html report in a job? try to find metadata from xml report at least (0..1 per job)--]
                    [#if htmlReportCountInJob == 0 && (resultsSummary.customBuildData.CLOVER_BUILD_COVERAGE)?has_content]
                        [#assign coverageNumber = numberUtils.unlocalizedStringToDouble(resultsSummary.customBuildData.CLOVER_BUILD_COVERAGE) /]
                        <tr>
                            <td>
                                <a href="${req.contextPath}/browse/${resultsSummary.planResultKey.key}" title="${resultsSummary.planResultKey.key}">
                                    ${action.getJobName(resultsSummary.planKey)}
                                </a>
                            </td>
                            <td>
                                [#-- viewCloverResult.action?buildKey=PRJ-PLAN-JOB&buildNumber=123 --]
                                <a href="${req.contextPath}/build/result/viewCloverResult.action?buildKey=${resultsSummary.planKey}&amp;buildNumber=${latestBuild.buildNumber}">
                                    [@s.text name='clover.plan.summary.reports.xml.report.name'/]
                                </a>
                                <span class="aui-lozenge aui-lozenge-subtle">xml</span>
                            </td>
                            <td>
                                [@renderCoverageBarWithLabel coverageNumber=coverageNumber barSize="medium"/]
                            </td>
                        </tr>
                    [/#if]
                [/#list]
            [/#list]

        </tbody>
    </table>

    <h2>[@s.text name='clover.plan.summary.historical.header'/]</h2>

    <div id="clover-graphs">
        [@s.action name="viewCloverCoverageSummary" namespace="/chain" executeResult="true" /]
        [@s.action name="viewCloverLinesOfCodeSummary" namespace="/chain" executeResult="true" /]
        [@s.action name="viewCloverNCLOCSummary" namespace="/chain" executeResult="true" /]
    </div>

[#else]
    <p>[@s.text name='clover.plan.summary.noData'/]</p>
[/#if]

</body>
</html>