[#-- @ftlvariable name="" type="com.atlassian.bamboo.clover.build.coverage.ViewCloverBuildResults" --]
[#-- @ftlvariable name="action" type="com.atlassian.bamboo.clover.build.coverage.ViewCloverBuildResults" --]
[#-- @ftlvariable name="numberUtils" type="com.atlassian.bamboo.util.NumberUtils" --]
<html>
<head>
	[@ui.header pageKey='clover.job.summary.title' object='${immutablePlan.name} ${resultsSummary.buildNumber}' title=true /]
    <meta name="tab" content="clover"/>
    ${webResourceManager.requireResource("com.atlassian.bamboo.plugin.clover:webCss")}
</head>

<body>

    <script type="text/javascript">
        function switchCloverReport(source, url, isAdgReport) {
            // mark the current link
            AJS.$('#clover-reports-list > li > a').removeClass('clover-report-selected');
            AJS.$(source).addClass('clover-report-selected');

            // load new report
            var iframeSelector = AJS.$('#clover-iframe');
            if (iframeSelector.length > 0) {
                iframeSelector.get(0).src = url;

                // add/remove scrollbar
                if (isAdgReport) {
                    iframeSelector.removeClass('clover-iframe-classic').addClass('clover-iframe-adg');
                } else {
                    iframeSelector.removeClass('clover-iframe-adg').addClass('clover-iframe-classic');
                }
            }
        }

        function openCloverReportInNewWindow() {
            var iframeSelector = AJS.$('#clover-iframe');
            if (iframeSelector.length > 0) {
                window.open(iframeSelector.get(0).src);
            }
        }
    </script>
    
    [#if action.jobsParentKey??]
        <p class="headingInfo">
            <a href="${req.contextPath}/chain/viewCloverSummary.action?buildKey=${action.jobsParentKey}">[@s.text name='clover.job.summary.viewPlanSummary'/]</a>
        </p>
    [/#if]
    [@ui.header pageKey='clover.job.summary.title'/]

[#if reportLinker.cloverArtifacts?has_content]

    [#-- list of reports with js to toggle them (only if more than one) --]
    [#if reportLinker.getCloverArtifacts().size() > 1]
        <h3>[@s.text name='clover.job.summary.coverageReports'/]</h3>
        <ul id="clover-reports-list">
        [#assign isFirstReport = true]
        [#list reportLinker.getCloverArtifacts() as cloverArtifact]
            <li>
                <a href="#" [#if isFirstReport]class="clover-report-selected"[/#if] onclick="
                        switchCloverReport(
                                this,
                                '${reportLinker.getCloverReportUrl(cloverArtifact)}',
                                [#if reportLinker.isCloverAdgReport(cloverArtifact)]true[#else]false[/#if]
                        );">
                    ${cloverArtifact.label}
                </a>
            </li>
            [#assign isFirstReport = false]
        [/#list]
        </ul>
    [/#if]

    [#-- button to open a report in a new tab --]
    <div class="aui-button aui-button-subtle floatRight singleMargin" onclick="openCloverReportInNewWindow();">
        <span class="aui-icon aui-icon-small aui-iconfont-share"></span>
        [@s.text name='clover.job.summary.openReport'/]
    </div>

    [#-- iframe with a first report --]
    [#assign cloverArtifact = reportLinker.getCloverArtifacts().iterator().next()]
    [#if reportLinker.isCloverAdgReport(cloverArtifact)]
        [#assign iframeClass="clover-iframe clover-iframe-adg"]
    [#else]
        [#assign iframeClass="clover-iframe clover-iframe-classic"]
    [/#if]
    [#-- note: Clover's ADG report needs a vertical scroll bar --]
    <div class="singlePadding">
        [#if embeddingEnabled]
            <iframe id="clover-iframe" class="${iframeClass}" src="${reportLinker.getCloverReportUrl(cloverArtifact)}">
                <p>[@s.text name='clover.job.summary.iframesNotSupported'/]</p>
            </iframe>
        [#else]
            [@ui.messageBox id="embedding-disabled-banner" type="warning"]
                [#if fn.hasAdminPermission()]
                    [@s.text name='clover.job.summary.embeddingNotEnabled.admin']
                        [@s.param][@s.url namespace='/admin' action='viewSecurity' /][/@s.param]
                    [/@s.text]
                [#else]
                    [@s.text name='clover.job.summary.embeddingNotEnabled.nonadmin'/]
                [/#if]
            [/@ui.messageBox]
        [/#if]
    </div>

[#else]

    [#macro cloverResultDivide dividendAsString divisorAsString ]
        [#assign dividend = numberUtils.unlocalizedStringToDouble(dividendAsString) /]
        [#assign divisor = numberUtils.unlocalizedStringToDouble(divisorAsString) /]
        [#compress ]
            [#if divisor == 0 ]
                -
            [#else ]
                ${(dividend / divisor)?string('0.0%')}
            [/#if]
        [/#compress]
    [/#macro]


    [#assign customDataMap=buildResultsSummary.customBuildData/]

    [#if customDataMap.CLOVER_BUILD_COVERAGE??]

        [@ui.bambooInfoDisplay titleKey='clover.testCoverage.title' float=true]

            [@s.label id='buildCoverage' labelKey='clover.testCoverage.build' descriptionKey='clover.testCoverage.build.description']
                [@s.param name='value']${(numberUtils.unlocalizedStringToDouble(customDataMap.CLOVER_BUILD_COVERAGE!) / 100)?string('0.0%')}
                [#if customDataMap.CLOVER_COVERAGE_DELTA?? ]
                    (${numberUtils.unlocalizedStringToDouble(customDataMap.CLOVER_COVERAGE_DELTA)?string('0.0%')})
                [/#if]
                [/@s.param]
            [/@s.label]

            [#if customDataMap.CLOVER_STATEMENTS?? && customDataMap.CLOVER_COVERED_STATEMENTS??]
                [@s.label labelKey='clover.testCoverage.statement' descriptionKey='clover.testCoverage.statement.description']
                    [@s.param name='value'][@cloverResultDivide customDataMap.CLOVER_COVERED_STATEMENTS customDataMap.CLOVER_STATEMENTS /][/@s.param]
                [/@s.label]
            [/#if]

            [#if customDataMap.CLOVER_METHODS?? && customDataMap.CLOVER_COVERED_METHODS??]
                [@s.label labelKey='clover.testCoverage.methods' descriptionKey='clover.testCoverage.methods.description']
                    [@s.param name='value'][@cloverResultDivide customDataMap.CLOVER_COVERED_METHODS customDataMap.CLOVER_METHODS /][/@s.param]
                [/@s.label]
            [/#if]

            [#if customDataMap.CLOVER_CONDITIONALS?? && customDataMap.CLOVER_COVERED_CONDITIONALS??]
                [@s.label labelKey='clover.testCoverage.conditionals' descriptionKey='clover.testCoverage.conditionals.description']
                    [@s.param name='value'][@cloverResultDivide customDataMap.CLOVER_COVERED_CONDITIONALS customDataMap.CLOVER_CONDITIONALS /][/@s.param]
                [/@s.label]
            [/#if]

        [/@ui.bambooInfoDisplay]


        [@ui.bambooInfoDisplay titleKey='clover.buildStatistics.title' float=true]

            [@s.label labelKey='clover.buildStatistics.loc' descriptionKey='clover.buildStatistics.loc.description'
                value='${customDataMap.CLOVER_LOC!}' /]
            [@s.label labelKey='clover.buildStatistics.ncloc' descriptionKey='clover.buildStatistics.ncloc.description'
                value='${customDataMap.CLOVER_NCLOC!}' /]
            [@s.label labelKey='clover.buildStatistics.files'
                value='${customDataMap.CLOVER_FILES!}' /]
            [@s.label labelKey='clover.buildStatistics.methods'
                value='${customDataMap.CLOVER_METHODS!}' /]
            [@s.label labelKey='clover.buildStatistics.classes'
                value='${customDataMap.CLOVER_CLASSES!}' /]
            [@s.label labelKey='clover.buildStatistics.packages'
                value='${customDataMap.CLOVER_PACKAGES!}' /]

        [/@ui.bambooInfoDisplay]
    [#else]
        <p>[@s.text name='clover.noCoverageData'/]</p>
    [/#if]

[/#if]

</body>
</html>