[#-- @ftlvariable name="action" type="com.atlassian.bamboo.ww2.actions.admin.ConfigureCloverPlugin" --]
[#-- @ftlvariable name="" type="com.atlassian.bamboo.ww2.actions.admin.ConfigureCloverPlugin" --]

<html>
<head>
    [@ui.header pageKey="clover.plugin.configure.title" title=true /]
    <meta name="decorator" content="adminpage">
    <meta name="adminCrumb" content="configureCloverPlugin">
</head>
<body>
[@ui.header pageKey="clover.plugin.configure.title" /]

[#assign licensePageInfo]
    [#if license??]
        [#if license.evaluation]
            [#if license.expired]
                [@s.text name='clover.license.expiry.expired.message' var='cloverLicenseExpiryExpiredMessage']
                    [@s.param][@s.date name='license.expiryDate' format='dd MMMM yyyy'/][/@s.param]
                [/@s.text]
                [@ui.messageBox type="warning" title=cloverLicenseExpiryExpiredMessage /]
            [#else]
                [@s.text name='license.expiry.expiring' var='licenseExpiryExpiring']
                    [@s.param][@s.date name='license.expiryDate' format='dd MMMM yyyy'/][/@s.param]
                [/@s.text]
                [@ui.messageBox type="info" title=licenseExpiryExpiring]
                    [@s.text name='license.contact']
                        [@s.param][@s.text name='license.contact.company' /][/@s.param]
                    [/@s.text]
                [/@ui.messageBox]
            [/#if]
        [#else]
            [#if license.maintenanceExpired]
                [@s.text name='clover.license.support.ended.message' var='licenseSupportEndedMessage']
                    [@s.param][@s.date name='license.maintenanceExpiryDate' format='dd MMMM yyyy'/][/@s.param]
                [/@s.text]
                [@ui.messageBox type="warning" title=licenseSupportEndedMessage /]
            [#else]
            <p>[@s.text name='clover.plugin.configure.form.title.description' /]</p>
            [/#if]
        [/#if]
    [/#if]
[/#assign]

[@ui.bambooPanel titleKey='clover.plugin.configure.form.title']
${licensePageInfo}
    [#if license??]
        [@s.label labelKey='license.organisation' name='license.organisation.name' /]
        [@s.label labelKey='license.datePurchased' ]
            [@s.param name='value'][@s.date name='license.purchaseDate' format='dd MMMM yyyy'/][/@s.param]
        [/@s.label]
        [@s.label labelKey='license.type' name='license.description' /]

        [#if license.maintenanceExpired]
            [@s.label labelKey='license.support.ended' ]
                [@s.param name='value'][@s.date name='license.maintenanceExpiryDate' format='dd MMMM yyyy'/][/@s.param]
            [/@s.label]
        [#else]
            [@s.label labelKey='license.support' ]
                [@s.param name='value'][@s.date name='license.maintenanceExpiryDate' format='dd MMMM yyyy'/][/@s.param]
            [/@s.label]
        [/#if]
    [/#if]
[/@ui.bambooPanel]

[@s.form id='configureCloverPlugin' action='updateConfigureCloverPlugin' submitLabelKey='clover.license.update.license']
    [@s.param name='buttons']
        [@cp.displayLinkButton buttonId="deleteButton" buttonLabel="clover.license.delete.license" buttonUrl='${req.contextPath}/admin/deleteConfigureCloverPlugin.action' cssClass="requireConfirmation" altText="delete the Clover license" mutative=true /]
    [/@s.param]
    [@ui.bambooSection titleKey='license.update.title' ]
        [@s.textarea labelKey='clover.plugin.configure.globalLicenseKey' name="licenseString" rows="8" cssClass="long-field" /]
    [/@ui.bambooSection]
[/@s.form]

</body>
</html>