/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.reports.collector;

import com.atlassian.bamboo.reports.collector.ReportCollector;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class CloverPerBuildCoverageCollector
implements ReportCollector {
    List<ResultsSummary> results;

    @NotNull
    public Dataset getDataset() {
        XYSeries series = new XYSeries((Comparable)((Object)" - "));
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        for (ResultsSummary result : this.results) {
            series.setKey((Comparable)((Object)result.getPlanKey().toString()));
            double coverage = this.extractCoverageResultFrom(result);
            series.add((double)result.getBuildNumber(), coverage);
        }
        return dataset;
    }

    private double extractCoverageResultFrom(ResultsSummary resultSummary) {
        return Optional.ofNullable(resultSummary.getCustomBuildData().get("CLOVER_BUILD_COVERAGE")).map(Double::parseDouble).orElse(-1.0);
    }

    public void setResultsList(@NotNull List<? extends ResultsSummary> resultsList) {
        this.results = new ArrayList<ResultsSummary>(resultsList);
    }

    public void setParams(@NotNull Map<String, String[]> params) {
    }

    public String getPeriodRange() {
        return "DAY";
    }
}

