/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.reports.charts;

import com.atlassian.bamboo.clover.builder.coverage.ValuesAggregator;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import org.apache.commons.lang3.Range;
import org.jetbrains.annotations.NotNull;
import org.jfree.data.xy.XYDataset;

public class RangeCalculator {
    @NotNull
    public static Optional<Range<Double>> getMinMaxFromSeries(@NotNull XYDataset dataSet, int seriesNumber) {
        ValuesAggregator minAggregator = ValuesAggregator.createMinimizing();
        ValuesAggregator maxAggregator = ValuesAggregator.createMaximizing();
        if (dataSet.getSeriesCount() > seriesNumber) {
            for (int i = 0; i < dataSet.getItemCount(seriesNumber); ++i) {
                double val = dataSet.getYValue(seriesNumber, i);
                minAggregator.addValue(val);
                maxAggregator.addValue(val);
            }
        }
        return minAggregator.isAggregatedAvailable() && maxAggregator.isAggregatedAvailable() ? Optional.of(Range.between((Comparable)Double.valueOf(minAggregator.getAggregatedValue()), (Comparable)Double.valueOf(maxAggregator.getAggregatedValue()))) : Optional.empty();
    }

    @NotNull
    public static Optional<Range<Double>> getMinMaxFromSeries(@NotNull XYDataset dataSet, int seriesNumber, double minimumRelativeMargin, double minimumAbsoluteMargin, double lowerBound, double upperBound) {
        return RangeCalculator.getMinMaxFromSeries(dataSet, seriesNumber).map(minMax -> Range.between((Comparable)Double.valueOf(RangeCalculator.correctValue((Double)minMax.getMinimum(), minimumRelativeMargin, minimumAbsoluteMargin, lowerBound, upperBound, -1.0)), (Comparable)Double.valueOf(RangeCalculator.correctValue((Double)minMax.getMaximum(), minimumRelativeMargin, minimumAbsoluteMargin, lowerBound, upperBound, 1.0))));
    }

    @VisibleForTesting
    static double correctValue(double value, double minimumRelativeMargin, double minimumAbsoluteMargin, double lowerBound, double upperBound, double negate) {
        double delta = Math.max(Math.abs(value) * minimumRelativeMargin, minimumAbsoluteMargin);
        return Math.max(Math.min(value + delta * negate, upperBound), lowerBound);
    }
}

