/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.reports.charts;

import com.atlassian.bamboo.clover.reports.charts.RangeCalculator;
import com.atlassian.bamboo.reports.charts.BambooReportLineChart;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class BuildSummaryCoverageLineChart
extends BambooReportLineChart
implements XYToolTipGenerator {
    private final I18nResolver i18nResolver;
    private static final Logger log = Logger.getLogger(BuildSummaryCoverageLineChart.class);

    public BuildSummaryCoverageLineChart(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
        this.setyAxisLabel("% Code Coverage");
    }

    public JFreeChart getJFreeChart() {
        JFreeChart jFreeChart = super.getJFreeChart();
        if (this.dataSet.getSeriesCount() == 1) {
            XYPlot xyPlot = jFreeChart.getXYPlot();
            RangeCalculator.getMinMaxFromSeries(this.dataSet, 0, 0.05, 5.0, 0.0, 100.0).ifPresent(minMax -> {
                ValueAxis rangeAxis = xyPlot.getRangeAxis();
                rangeAxis.setLowerBound(((Double)minMax.getMinimum()).doubleValue());
                rangeAxis.setUpperBound(((Double)minMax.getMaximum()).doubleValue());
            });
        } else {
            log.warn((Object)String.format("Data set for a chart contains %d series instead of 1", this.dataSet.getSeriesCount()));
        }
        return jFreeChart;
    }

    public String generateToolTip(XYDataset xyDataset, int series, int item) {
        TimeTableXYDataset dataset = (TimeTableXYDataset)xyDataset;
        double percentageCovered = dataset.getYValue(series, item);
        String buildKey = (String)((Object)dataset.getSeriesKey(series));
        TimePeriod timePeriod = dataset.getTimePeriod(item);
        return this.i18nResolver.getText("clover.charts.coverage.tooltip", new Serializable[]{timePeriod.toString(), Double.valueOf(NumberUtils.round((double)percentageCovered, (int)1)), buildKey});
    }
}

