/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.reports.charts;

import com.atlassian.bamboo.clover.reports.charts.RangeCalculator;
import com.atlassian.bamboo.reports.charts.BambooReportLineChart;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class BuildSummaryCodeLinesLineChart
extends BambooReportLineChart
implements XYToolTipGenerator {
    private static final Logger log = Logger.getLogger(BuildSummaryCodeLinesLineChart.class);
    private final I18nResolver i18nResolver;

    public BuildSummaryCodeLinesLineChart(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public String generateToolTip(XYDataset xyDataset, int series, int item) {
        TimeTableXYDataset dataset = (TimeTableXYDataset)Narrow.to((Object)xyDataset, TimeTableXYDataset.class);
        if (dataset != null) {
            double lines = dataset.getYValue(series, item);
            String buildKey = (String)((Object)dataset.getSeriesKey(series));
            TimePeriod timePeriod = dataset.getTimePeriod(item);
            return this.i18nResolver.getText("clover.charts.locncloc.tooltip", new Serializable[]{buildKey, Double.valueOf(lines), timePeriod.toString()});
        }
        return "";
    }

    public JFreeChart getJFreeChart() {
        JFreeChart chart = super.getJFreeChart();
        if (this.dataSet.getSeriesCount() == 1) {
            RangeCalculator.getMinMaxFromSeries(this.dataSet, 0, 0.05, 10.0, 0.0, Double.MAX_VALUE).ifPresent(minMax -> {
                ValueAxis rangeAxis = chart.getXYPlot().getRangeAxis();
                rangeAxis.setLowerBound(((Double)minMax.getMinimum()).doubleValue());
                rangeAxis.setUpperBound(((Double)minMax.getMaximum()).doubleValue());
            });
        } else {
            log.warn((Object)String.format("Data set for a chart contains %d series instead of 1", this.dataSet.getSeriesCount()));
        }
        return chart;
    }
}

