/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.reports.charts;

import com.atlassian.bamboo.charts.utils.ChartDefaults;
import com.atlassian.bamboo.charts.utils.ChartUtil;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.reports.charts.BambooReportLineChart;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.NumberUtils;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.Date;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;

public class BuildNumberCoverageLineChart
extends BambooReportLineChart
implements XYToolTipGenerator,
XYURLGenerator {
    public BuildNumberCoverageLineChart() {
        this.setyAxisLabel("% Code Coverage");
    }

    public JFreeChart getJFreeChart() {
        JFreeChart jFreeChart1 = super.getJFreeChart();
        XYPlot xyPlot = jFreeChart1.getXYPlot();
        xyPlot.getRangeAxis().setUpperBound(100.0);
        if (this.dataSet.getSeriesCount() == 1) {
            XYAreaRenderer renderer = new XYAreaRenderer(5);
            ChartUtil.populateRendererDefaults((XYToolTipGenerator)this, (XYSeriesLabelGenerator)this, (AbstractXYItemRenderer)renderer);
            renderer.setOutline(true);
            renderer.setSeriesOutlinePaint(0, (Paint)ChartDefaults.BRIGHT_GREEN);
            renderer.setSeriesPaint(0, (Paint)ChartDefaults.GREEN_DIFF);
            int w = 4;
            Ellipse2D.Float shape = new Ellipse2D.Float(-2.0f, -2.0f, 4.0f, 4.0f);
            renderer.setSeriesShape(0, (Shape)shape);
            renderer.setURLGenerator((XYURLGenerator)this);
            xyPlot.setDomainAxis(0, (ValueAxis)new NumberAxis());
            xyPlot.setRenderer((XYItemRenderer)renderer);
        }
        return jFreeChart1;
    }

    public String generateURL(XYDataset dataset, int series, int item) {
        Number buildNumber = dataset.getX(series, item);
        String buildKey = (String)((Object)dataset.getSeriesKey(series));
        return "viewCloverResult.action?buildKey=" + buildKey + "&buildNumber=" + buildNumber.intValue();
    }

    public String generateToolTip(XYDataset dataset, int series, int item) {
        double percentageCovered = dataset.getYValue(series, item);
        String buildKey = (String)((Object)dataset.getSeriesKey(series));
        int buildNumber = dataset.getX(series, item).intValue();
        PlanResultKey resultKey = PlanKeys.getPlanResultKey((String)buildKey, (int)buildNumber);
        ResultsSummary resultSummary = this.resultsSummaryManager.getResultsSummary(resultKey);
        Date buildDate = resultSummary.getBuildCompletedDate();
        return String.format("Build %d on %tc covered %.1f%%", buildNumber, buildDate, NumberUtils.round((double)percentageCovered, (int)1));
    }
}

