/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.builder.coverage;

public abstract class ValuesAggregator {
    protected double sum;
    protected double min = Double.MAX_VALUE;
    protected double max = Double.MIN_VALUE;
    protected long count;

    public static ValuesAggregator createSummational() {
        return new ValuesAggregator(){

            @Override
            public double getAggregatedValue() {
                return this.count == 0L ? Double.NaN : this.sum;
            }
        };
    }

    public static ValuesAggregator createAveraging() {
        return new ValuesAggregator(){

            @Override
            public double getAggregatedValue() {
                return this.count == 0L ? Double.NaN : this.sum / (double)this.count;
            }
        };
    }

    public static ValuesAggregator createMaximizing() {
        return new ValuesAggregator(){

            @Override
            public double getAggregatedValue() {
                return this.count == 0L ? Double.NaN : this.max;
            }
        };
    }

    public static ValuesAggregator createMinimizing() {
        return new ValuesAggregator(){

            @Override
            public double getAggregatedValue() {
                return this.count == 0L ? Double.NaN : this.min;
            }
        };
    }

    public void addValue(double value) {
        if (!Double.isNaN(value)) {
            this.sum += value;
            this.min = Math.min(value, this.min);
            this.max = Math.max(value, this.max);
            ++this.count;
        }
    }

    public abstract double getAggregatedValue();

    public boolean isAggregatedAvailable() {
        return this.count > 0L;
    }
}

