/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.builder.coverage;

import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.security.xml.SecureXmlParserFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CloverReportParser {
    private static final Logger log = Logger.getLogger(CloverReportParser.class);

    @Nullable
    public ProjectMetrics parse(final @NotNull InputStream stream) {
        return this.parse(new ParserRunnable(){

            @Override
            public void run(@NotNull SAXParser parser, @NotNull DefaultHandler handler) throws Exception {
                parser.parse(stream, handler);
            }
        });
    }

    @Nullable
    public ProjectMetrics parse(final @NotNull File file) {
        return this.parse(new ParserRunnable(){

            @Override
            public void run(@NotNull SAXParser parser, @NotNull DefaultHandler handler) throws Exception {
                parser.parse(file, handler);
            }
        });
    }

    @Nullable
    protected ProjectMetrics parse(@NotNull ParserRunnable runnable) {
        CloverXmlHandler handler = new CloverXmlHandler();
        try {
            SAXParser parser = this.createSAXParser();
            runnable.run(parser, handler);
        }
        catch (MetricsFoundSaxException ex) {
            return handler.getProjectMetrics();
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    @VisibleForTesting
    protected SAXParser createSAXParser() throws ParserConfigurationException, SAXException {
        return SecureXmlParserFactory.createSAXParserFactory().newSAXParser();
    }

    private static class MetricsFoundSaxException
    extends SAXException {
        private MetricsFoundSaxException() {
        }
    }

    @VisibleForTesting
    protected static class CloverXmlHandler
    extends DefaultHandler {
        private static final List PATH_TO_PROJECT_METRICS = Lists.newArrayList((Object[])new String[]{"metrics", "project", "coverage"});
        private LinkedList<String> domPath;
        @Nullable
        private ProjectMetrics metrics;

        protected CloverXmlHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            this.metrics = new ProjectMetrics();
            this.domPath = new LinkedList();
        }

        @Override
        public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) throws SAXException {
            this.domPath.push(this.nonQualifiedName(qName));
            if (this.isInProjectMetrics()) {
                this.parseProjectMetrics(attributes);
                throw new MetricsFoundSaxException();
            }
        }

        @Override
        public void endElement(@NotNull String uri, @NotNull String localName, @NotNull String qName) throws SAXException {
            String tagName = this.nonQualifiedName(qName);
            String fromStack = this.domPath.pop();
            if (!StringUtils.equals((CharSequence)fromStack, (CharSequence)tagName)) {
                throw new SAXException("Invalid closing tag. Expected '" + tagName + "' but found '" + fromStack + "'");
            }
        }

        private boolean isInProjectMetrics() {
            return ListUtils.isEqualList((Collection)PATH_TO_PROJECT_METRICS, this.domPath);
        }

        @NotNull
        private String nonQualifiedName(@NotNull String qName) {
            return qName.contains(":") ? StringUtils.substringAfterLast((String)qName, (String)":") : qName;
        }

        private void parseProjectMetrics(@NotNull Attributes attributes) throws SAXException {
            if (this.metrics == null) {
                throw new SAXException("Invalid " + CloverXmlHandler.class.getName() + "state (metrics==null)");
            }
            this.metrics.coveredElements = this.getLongValue(attributes, "coveredelements");
            this.metrics.elements = this.getLongValue(attributes, "elements");
            this.metrics.files = this.getLongValue(attributes, "files");
            this.metrics.classes = this.getLongValue(attributes, "classes");
            this.metrics.coveredConditionals = this.getLongValue(attributes, "coveredconditionals");
            this.metrics.conditionals = this.getLongValue(attributes, "conditionals");
            this.metrics.packages = this.getLongValue(attributes, "packages");
            this.metrics.loc = this.getLongValue(attributes, "loc");
            this.metrics.ncloc = this.getLongValue(attributes, "ncloc");
            this.metrics.statements = this.getLongValue(attributes, "statements");
            this.metrics.coveredStatements = this.getLongValue(attributes, "coveredstatements");
            this.metrics.methods = this.getLongValue(attributes, "methods");
            this.metrics.coveredMethods = this.getLongValue(attributes, "coveredmethods");
        }

        private long getLongValue(@NotNull Attributes attributes, @NotNull String attribute) {
            String stringValue = attributes.getValue(attribute);
            if (stringValue != null) {
                try {
                    return Long.parseLong(stringValue);
                }
                catch (NumberFormatException ex) {
                    return 0L;
                }
            }
            return 0L;
        }

        @Nullable
        public ProjectMetrics getProjectMetrics() {
            return this.metrics;
        }
    }

    private static interface ParserRunnable {
        public void run(SAXParser var1, DefaultHandler var2) throws Exception;
    }

    public static class ProjectMetrics {
        private long coveredElements;
        private long elements;
        private long files;
        private long classes;
        private long coveredConditionals;
        private long conditionals;
        private long packages;
        private long loc;
        private long ncloc;
        private long statements;
        private long coveredStatements;
        private long methods;
        private long coveredMethods;

        public long getCoveredElements() {
            return this.coveredElements;
        }

        public long getElements() {
            return this.elements;
        }

        public long getFiles() {
            return this.files;
        }

        public long getClasses() {
            return this.classes;
        }

        public long getCoveredConditionals() {
            return this.coveredConditionals;
        }

        public long getConditionals() {
            return this.conditionals;
        }

        public long getPackages() {
            return this.packages;
        }

        public long getLoc() {
            return this.loc;
        }

        public long getNcloc() {
            return this.ncloc;
        }

        public long getStatements() {
            return this.statements;
        }

        public long getCoveredStatements() {
            return this.coveredStatements;
        }

        public long getMethods() {
            return this.methods;
        }

        public long getCoveredMethods() {
            return this.coveredMethods;
        }

        public double getProjectCoveragePercentage() {
            if (this.elements == 0L) {
                return 0.0;
            }
            double result = (double)this.coveredElements * 100.0 / (double)this.elements;
            return NumberUtils.round((double)result, (int)1);
        }
    }
}

