/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.builder.coverage;

import com.atlassian.bamboo.index.CustomIndexReader;
import com.atlassian.bamboo.index.IndexUtils;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import org.apache.lucene.document.Document;
import org.jetbrains.annotations.Nullable;

public class CloverIndexReader
implements CustomIndexReader {
    public void extractFromDocument(Document document, BuildResultsSummary buildResultsSummary) {
        Double coverage = IndexUtils.getOptionalDoubleField((Document)document, (String)"CLOVER_BUILD_COVERAGE");
        this.addToCustomDataIfNotNull(buildResultsSummary, "CLOVER_BUILD_COVERAGE", coverage);
        Double ncloc = IndexUtils.getOptionalDoubleField((Document)document, (String)"CLOVER_NCLOC");
        this.addToCustomDataIfNotNull(buildResultsSummary, "CLOVER_NCLOC", ncloc);
        Double loc = IndexUtils.getOptionalDoubleField((Document)document, (String)"CLOVER_LOC");
        this.addToCustomDataIfNotNull(buildResultsSummary, "CLOVER_LOC", loc);
    }

    private void addToCustomDataIfNotNull(BuildResultsSummary buildResultsSummary, String key, @Nullable Double value) {
        if (value == null) {
            return;
        }
        buildResultsSummary.getCustomBuildData().put(key, Double.toString(value));
    }
}

