/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.builder.coverage;

import com.atlassian.bamboo.build.CustomBuildProcessorServer;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.task.AbstractBuildTask;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.Map;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class CloverDeltaCalculator
extends AbstractBuildTask
implements CustomBuildProcessorServer {
    @Inject
    private ResultsSummaryManager resultsSummaryManager;
    @Inject
    private TransactionTemplate transactionTemplate;

    @NotNull
    public BuildContext call() {
        return (BuildContext)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<BuildContext>(){

            public BuildContext doInTransaction() {
                return CloverDeltaCalculator.this.callInTransaction();
            }
        });
    }

    @NotNull
    protected BuildContext callInTransaction() {
        Map customBuildData;
        String currentCoverageString;
        String prevCoverStr;
        ResultsSummary previousSummary = this.getPreviousBuildResultsSummary();
        if (previousSummary != null && (prevCoverStr = (String)previousSummary.getCustomBuildData().get("CLOVER_BUILD_COVERAGE")) != null && (currentCoverageString = (String)(customBuildData = this.buildContext.getBuildResult().getCustomBuildData()).get("CLOVER_BUILD_COVERAGE")) != null) {
            double currentCoverage = Double.parseDouble(currentCoverageString);
            customBuildData.put("CLOVER_COVERAGE_DELTA", Double.toString(NumberUtils.round((double)(currentCoverage - Double.parseDouble(prevCoverStr)), (int)4)));
        }
        return this.buildContext;
    }

    protected ResultsSummary getPreviousBuildResultsSummary() {
        return this.resultsSummaryManager.getLastSuccessfulResultSummary(this.buildContext.getPlanResultKey().getPlanKey());
    }

    @Deprecated
    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    @Deprecated
    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }
}

