/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.builder.coverage;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.plugins.PostChainAction;
import com.atlassian.bamboo.clover.builder.coverage.ValuesAggregator;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CloverChainResultAggregator
implements PostChainAction {
    private static final Logger log = Logger.getLogger(CloverChainResultAggregator.class);

    public void execute(@NotNull Chain chain, @NotNull ChainResultsSummary chainResultsSummary, @NotNull ChainExecution chainExecution) throws InterruptedException, Exception {
        if (!chainResultsSummary.isSuccessful()) {
            return;
        }
        ValuesAggregator coverageAggregator = ValuesAggregator.createAveraging();
        ValuesAggregator nclocAggregator = ValuesAggregator.createSummational();
        ValuesAggregator locAggregator = ValuesAggregator.createSummational();
        for (ChainStageResult stageResult : chainResultsSummary.getStageResults()) {
            for (BuildResultsSummary buildResult : stageResult.getBuildResults()) {
                this.addValue(buildResult, coverageAggregator, "CLOVER_BUILD_COVERAGE");
                this.addValue(buildResult, nclocAggregator, "CLOVER_NCLOC");
                this.addValue(buildResult, locAggregator, "CLOVER_LOC");
            }
        }
        this.putAggregatedValueIfAvailable(chainResultsSummary, coverageAggregator, "CLOVER_BUILD_COVERAGE");
        this.putAggregatedValueIfAvailable(chainResultsSummary, locAggregator, "CLOVER_LOC");
        this.putAggregatedValueIfAvailable(chainResultsSummary, nclocAggregator, "CLOVER_NCLOC");
    }

    private void addValue(@NotNull BuildResultsSummary buildResultsSummary, @NotNull ValuesAggregator aggregator, @NotNull String key) {
        String value = (String)buildResultsSummary.getCustomBuildData().get(key);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            try {
                aggregator.addValue(Double.parseDouble(value));
            }
            catch (NumberFormatException ignored) {
                log.debug((Object)("Invalid value (" + value + ") found in " + key + ". Ignoring it."));
            }
        }
    }

    private void putAggregatedValueIfAvailable(@NotNull ChainResultsSummary chainResultsSummary, @NotNull ValuesAggregator aggregator, @NotNull String key) {
        if (aggregator.isAggregatedAvailable()) {
            chainResultsSummary.getCustomBuildData().put(key, Double.toString(aggregator.getAggregatedValue()));
        }
    }
}

