/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.builder.coverage;

import com.atlassian.bamboo.build.CustomBuildProcessor;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.clover.CloverPluginHelper;
import com.atlassian.bamboo.clover.builder.coverage.CloverReportParser;
import com.atlassian.bamboo.fieldvalue.TaskConfigurationUtils;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.PluginKeyProvider;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskProcessCommandDecoratorModuleDescriptor;
import com.atlassian.bamboo.task.plugins.TaskProcessCommandDecorator;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.FileVisitor;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BaseConfigurableBuildPlugin;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.ModuleDescriptor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloverBuildProcessor
extends BaseConfigurableBuildPlugin
implements CustomBuildProcessor {
    private static final Logger log = Logger.getLogger(CloverBuildProcessor.class);
    private static final String CLOVER_XML_PATH_KEY = "custom.clover.path";
    public static final String CLOVER_EXISTS = "custom.clover.exists";
    public static final String CLOVER_INTEGRATION = "custom.clover.integration";
    public static final String CLOVER_INTEGRATION_CUSTOM = "custom";
    public static final String CLOVER_INTEGRATION_AUTO = "auto";
    public static final String CLOVER_INTEGRATON_TOOL = "custom.clover.tool";
    public static final String COVERAGE_TOOL_ATLASSIAN_CLOVER = "atlassianclover";
    public static final String COVERAGE_TOOL_OPENCLOVER = "openclover";
    public static final String CLOVER_JSON = "custom.clover.json";
    public static final String CLOVER_HISTORICAL = "custom.clover.historical";
    public static final String CLOVER_OPTIMIZE = "custom.clover.optimize";
    public static final String CLOVER_BUILD_COVERAGE = "CLOVER_BUILD_COVERAGE";
    public static final String CLOVER_COVERAGE_DELTA = "CLOVER_COVERAGE_DELTA";
    public static final String CLOVER_ELEMENTS = "CLOVER_ELEMENTS";
    public static final String CLOVER_COVERED_ELEMENTS = "CLOVER_COVERED_ELEMENTS";
    public static final String CLOVER_PACKAGES = "CLOVER_PACKAGES";
    public static final String CLOVER_CONDITIONALS = "CLOVER_CONDITIONALS";
    public static final String CLOVER_COVERED_CONDITIONALS = "CLOVER_COVERED_CONDITIONALS";
    public static final String CLOVER_LOC = "CLOVER_LOC";
    public static final String CLOVER_NCLOC = "CLOVER_NCLOC";
    public static final String CLOVER_STATEMENTS = "CLOVER_STATEMENTS";
    public static final String CLOVER_COVERED_STATEMENTS = "CLOVER_COVERED_STATEMENTS";
    public static final String CLOVER_FILES = "CLOVER_FILES";
    public static final String CLOVER_METHODS = "CLOVER_METHODS";
    public static final String CLOVER_COVERED_METHODS = "CLOVER_COVERED_METHODS";
    public static final String CLOVER_CLASSES = "CLOVER_CLASSES";
    public static final String CLOVER_REPORT_ARTIFACT_PREFIX = "Clover Report";
    public static final String CLOVER_REPORT_ARTIFACT_LABEL = "Clover Report (System)";
    public static final String CLOVER_HAS_GLOBAL_LICENSE = "cloverHasGlobalLicense";
    public static final String CLOVER_HAS_VALID_GLOBAL_LICENSE = "cloverHasValidGlobalLicense";
    private static final Map<String, String> CLOVER_INTEGRATION_OPTIONS = new LinkedHashMap<String, String>(){
        {
            this.put(CloverBuildProcessor.CLOVER_INTEGRATION_AUTO, "Automatically integrate a code coverage tool into this job.");
            this.put(CloverBuildProcessor.CLOVER_INTEGRATION_CUSTOM, "I already integrated a code coverage tool in this job.");
        }
    };
    private static final Map<String, String> COVERAGE_INTEGRATION_TOOLS = new LinkedHashMap<String, String>(){
        {
            this.put(CloverBuildProcessor.COVERAGE_TOOL_ATLASSIAN_CLOVER, "Atlassian Clover");
            this.put(CloverBuildProcessor.COVERAGE_TOOL_OPENCLOVER, "OpenClover");
        }
    };
    private static final Predicate<PluginKeyProvider> IS_ANT_TASK = BambooPluginUtils.pluginKeyEquals((String)"com.atlassian.bamboo.plugins.ant:task.builder.ant");
    private static final Predicate<PluginKeyProvider> IS_GRAILS_TASK = BambooPluginUtils.pluginKeyEquals((String)"com.atlassian.bamboo.plugins:grailsBuilderTaskType");
    private static final Predicate<PluginKeyProvider> IS_MAVEN2_TASK = BambooPluginUtils.pluginKeyEquals((String)"com.atlassian.bamboo.plugins.maven:task.builder.mvn2");
    private static final Predicate<PluginKeyProvider> IS_MAVEN3_TASK = BambooPluginUtils.pluginKeyEquals((String)"com.atlassian.bamboo.plugins.maven:task.builder.mvn3");
    @Inject
    private ArtifactDefinitionManager artifactDefinitionManager;
    @Inject
    private BandanaManager bandanaManager;
    @Inject
    private PlanManager planManager;

    @NotNull
    public BuildContext call() throws Exception {
        Map customConfiguration = this.buildContext.getBuildDefinition().getCustomConfiguration();
        if (!CloverPluginHelper.isCloverOn(customConfiguration)) {
            return this.buildContext;
        }
        String pathPattern = (String)customConfiguration.get(CLOVER_XML_PATH_KEY);
        if (StringUtils.isEmpty((CharSequence)pathPattern)) {
            throw new IllegalStateException("Clover result path is empty, but Clover integration is enabled");
        }
        LinkedHashSet<File> directoriesToScan = this.getDirectoriesToScan(customConfiguration);
        CloverFileLocator locator = null;
        for (File directoryToScan : directoriesToScan) {
            locator = new CloverFileLocator(directoryToScan);
            locator.visitFilesThatMatch(pathPattern);
            if (locator.getFile() == null) continue;
            break;
        }
        assert (locator != null);
        File cloverXmlFile = locator.getFile();
        if (cloverXmlFile == null) {
            throw new Exception("No file matches the specified pattern:" + pathPattern + " in " + directoriesToScan);
        }
        HashMap<String, String> cloverResults = new HashMap<String, String>();
        this.processCloverResultsFile(cloverXmlFile, cloverResults);
        CurrentBuildResult buildResult = this.buildContext.getBuildResult();
        buildResult.getCustomBuildData().putAll(cloverResults);
        return this.buildContext;
    }

    private LinkedHashSet<File> getDirectoriesToScan(Map<String, String> configuration) {
        LinkedHashSet<File> directories = new LinkedHashSet<File>();
        File buildWorkingDirectory = BuildContextHelper.getBuildWorkingDirectory((CommonContext)this.buildContext);
        if (!CloverPluginHelper.isAutoIntegrate(configuration)) {
            directories.add(buildWorkingDirectory);
        }
        ArrayList tasksDecoratedByClover = new ArrayList();
        List supportedDecorators = this.moduleDescriptor.getPlugin().getModuleDescriptorsByModuleClass(TaskProcessCommandDecorator.class);
        for (ModuleDescriptor supportedDecorator : supportedDecorators) {
            TaskProcessCommandDecoratorModuleDescriptor taskProcessCommandDecoratorModuleDescriptor = (TaskProcessCommandDecoratorModuleDescriptor)Narrow.downTo((Object)supportedDecorator, TaskProcessCommandDecoratorModuleDescriptor.class);
            if (taskProcessCommandDecoratorModuleDescriptor == null) continue;
            Set decorableTaskTypeKeys = taskProcessCommandDecoratorModuleDescriptor.getDecorableTaskTypeKeys();
            for (String decorableTaskTypeKey : decorableTaskTypeKeys) {
                Iterables.addAll(tasksDecoratedByClover, (Iterable)BambooPluginUtils.filterTasks((BuildContext)this.buildContext, (String)decorableTaskTypeKey));
            }
        }
        for (TaskDefinition taskDefinition : tasksDecoratedByClover) {
            String workingSubdirectory = (String)taskDefinition.getConfiguration().get("workingSubDirectory");
            if (workingSubdirectory == null) continue;
            directories.add(new File(buildWorkingDirectory, workingSubdirectory));
        }
        if (CloverPluginHelper.isAutoIntegrate(configuration)) {
            directories.add(BuildContextHelper.getBuildWorkingDirectory((CommonContext)this.buildContext));
        }
        return directories;
    }

    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
        if (buildConfiguration.getProperty(CLOVER_INTEGRATION) == null) {
            buildConfiguration.setProperty(CLOVER_INTEGRATION, (Object)CLOVER_INTEGRATION_CUSTOM);
        }
        if (buildConfiguration.getProperty(CLOVER_INTEGRATON_TOOL) == null) {
            buildConfiguration.setProperty(CLOVER_INTEGRATON_TOOL, (Object)COVERAGE_TOOL_OPENCLOVER);
        }
    }

    public void customizeBuildRequirements(@NotNull PlanKey planKey, @NotNull BuildConfiguration buildConfiguration, @NotNull RequirementSet requirementSet) {
        Job job = (Job)this.planManager.getPlanByKeyIfOfType(planKey, Job.class);
        if (job != null) {
            ArtifactDefinition artifact;
            ImmutableList tasks = ImmutableList.copyOf((Collection)TaskConfigurationUtils.getTaskDefinitionsFromConfig((String)"buildTasks.", (HierarchicalConfiguration)buildConfiguration).stream().filter(IS_ANT_TASK.or(IS_GRAILS_TASK).or(IS_MAVEN2_TASK).or(IS_MAVEN3_TASK)).collect(Collectors.toList()));
            if (tasks.isEmpty()) {
                log.warn((Object)"No tasks defined. Clover instrumentation will not have any effect");
                return;
            }
            if (tasks.size() > 1) {
                log.warn((Object)"Multiple tasks defined. Only first task will be instrumented by Clover");
            }
            String reportDir = this.getReportDirPath((TaskDefinition)tasks.get(0));
            ArtifactDefinition artifactDefinition = this.artifactDefinitionManager.findArtifactDefinition((ImmutablePlan)job, CLOVER_REPORT_ARTIFACT_LABEL);
            List artifacts = buildConfiguration.getList("artifacts.artifact.label");
            int index = artifacts.indexOf(CLOVER_REPORT_ARTIFACT_LABEL);
            boolean autoArtifactExists = artifactDefinition != null;
            boolean autoIntegrate = CloverPluginHelper.isAutoIntegrate(buildConfiguration);
            boolean cloverEnabled = CloverPluginHelper.isCloverOn(buildConfiguration);
            if (cloverEnabled && !autoArtifactExists) {
                ArtifactDefinitionImpl artifact2 = new ArtifactDefinitionImpl(CLOVER_REPORT_ARTIFACT_LABEL, reportDir, "**/*.*");
                artifact2.setProducerJob(job);
                this.artifactDefinitionManager.saveArtifactDefinition((ArtifactDefinition)artifact2);
            } else if (!cloverEnabled && (artifact = this.artifactDefinitionManager.findArtifactDefinition((ImmutablePlan)job, CLOVER_REPORT_ARTIFACT_LABEL)) != null) {
                this.artifactDefinitionManager.removeArtifactDefinition(artifact);
            }
            if (autoIntegrate) {
                buildConfiguration.clearProperty(CLOVER_XML_PATH_KEY);
                buildConfiguration.addProperty(CLOVER_XML_PATH_KEY, (Object)(reportDir + File.separator + "**" + File.separator + "clover.xml"));
            }
        }
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration configuration) {
        SimpleErrorCollection ec = new SimpleErrorCollection();
        if (CloverPluginHelper.isCloverOn(configuration)) {
            if (configuration.getProperty(CLOVER_INTEGRATION) == null) {
                ec.addError(CLOVER_INTEGRATION, "Please select an integration option for code coverage.");
            }
            if (CLOVER_INTEGRATION_AUTO.equals(configuration.getProperty(CLOVER_INTEGRATION)) && configuration.getProperty(CLOVER_INTEGRATON_TOOL) == null) {
                ec.addError(CLOVER_INTEGRATON_TOOL, "Please select a code coverage tool to use.");
            }
            if (CLOVER_INTEGRATION_CUSTOM.equals(configuration.getString(CLOVER_INTEGRATION)) && StringUtils.isBlank((CharSequence)configuration.getString(CLOVER_XML_PATH_KEY))) {
                ec.addError(CLOVER_XML_PATH_KEY, "Please specify the directory containing the coverage report files.");
            }
        }
        return ec;
    }

    @NotNull
    public Set<String> getConfigurationKeys() {
        return ImmutableSet.of((Object)CLOVER_EXISTS, (Object)CLOVER_INTEGRATION, (Object)CLOVER_INTEGRATON_TOOL, (Object)CLOVER_XML_PATH_KEY, (Object)CLOVER_HISTORICAL, (Object)CLOVER_JSON, (Object[])new String[]{CLOVER_OPTIMIZE});
    }

    protected void populateContextForView(@NotNull Map<String, Object> context, @NotNull Plan build) {
        context.put(CLOVER_HAS_GLOBAL_LICENSE, CloverPluginHelper.hasGlobalLicenseKey(this.bandanaManager));
        context.put(CLOVER_HAS_VALID_GLOBAL_LICENSE, CloverPluginHelper.hasValidGlobalLicenseKey(this.bandanaManager));
    }

    protected void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull BuildConfiguration buildConfiguration, @Nullable Plan plan) {
        context.put("cloverIntegrationOptions", CLOVER_INTEGRATION_OPTIONS);
        context.put("coverageIntegrationTools", COVERAGE_INTEGRATION_TOOLS);
        context.put(CLOVER_HAS_GLOBAL_LICENSE, CloverPluginHelper.hasGlobalLicenseKey(this.bandanaManager));
        context.put(CLOVER_HAS_VALID_GLOBAL_LICENSE, CloverPluginHelper.hasValidGlobalLicenseKey(this.bandanaManager));
        if (CloverPluginHelper.isCloverOn(buildConfiguration) && buildConfiguration.getProperty(CLOVER_INTEGRATION) == null) {
            buildConfiguration.addProperty(CLOVER_INTEGRATION, (Object)CLOVER_INTEGRATION_CUSTOM);
        }
    }

    private String getReportDirPath(@NotNull TaskDefinition taskDefinition) {
        String taskKey = taskDefinition.getPluginKey();
        boolean isAnt = taskKey.contains("ant");
        boolean isGrails = taskKey.contains("grails");
        StringBuilder reportDirBuilder = new StringBuilder();
        String workingSubdirectory = (String)taskDefinition.getConfiguration().get("workingSubDirectory");
        if (StringUtils.isNotEmpty((CharSequence)workingSubdirectory)) {
            reportDirBuilder.append(workingSubdirectory).append("/");
        }
        if (isAnt) {
            reportDirBuilder.append("clover");
        } else if (isGrails) {
            reportDirBuilder.append("target/clover/report");
        } else {
            reportDirBuilder.append("target/site/clover");
        }
        return reportDirBuilder.toString();
    }

    private void processCloverResultsFile(@NotNull File file, @NotNull Map<String, String> cloverResults) {
        CloverReportParser parser = new CloverReportParser();
        CloverReportParser.ProjectMetrics metrics = parser.parse(file);
        if (metrics != null) {
            cloverResults.put(CLOVER_BUILD_COVERAGE, Double.toString(metrics.getProjectCoveragePercentage()));
            cloverResults.put(CLOVER_ELEMENTS, Long.toString(metrics.getElements()));
            cloverResults.put(CLOVER_COVERED_ELEMENTS, Long.toString(metrics.getCoveredElements()));
            cloverResults.put(CLOVER_PACKAGES, Long.toString(metrics.getPackages()));
            cloverResults.put(CLOVER_CONDITIONALS, Long.toString(metrics.getConditionals()));
            cloverResults.put(CLOVER_COVERED_CONDITIONALS, Long.toString(metrics.getCoveredConditionals()));
            cloverResults.put(CLOVER_LOC, Long.toString(metrics.getLoc()));
            cloverResults.put(CLOVER_NCLOC, Long.toString(metrics.getNcloc()));
            cloverResults.put(CLOVER_STATEMENTS, Long.toString(metrics.getStatements()));
            cloverResults.put(CLOVER_COVERED_STATEMENTS, Long.toString(metrics.getCoveredStatements()));
            cloverResults.put(CLOVER_FILES, Long.toString(metrics.getFiles()));
            cloverResults.put(CLOVER_METHODS, Long.toString(metrics.getMethods()));
            cloverResults.put(CLOVER_COVERED_METHODS, Long.toString(metrics.getCoveredMethods()));
            cloverResults.put(CLOVER_CLASSES, Long.toString(metrics.getClasses()));
        } else {
            log.warn((Object)("No project metrics found in Clover's XML report " + file));
        }
    }

    @Deprecated
    public void setArtifactDefinitionManager(ArtifactDefinitionManager artifactDefinitionManager) {
        this.artifactDefinitionManager = artifactDefinitionManager;
    }

    @Deprecated
    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    @Deprecated
    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    private static class CloverFileLocator
    extends FileVisitor {
        private File file;

        private CloverFileLocator(@NotNull File planSourceDirectory) {
            super(planSourceDirectory);
        }

        public void visitFile(@NotNull File file) throws InterruptedException {
            if (file.getName().endsWith("xml")) {
                if (this.file == null) {
                    this.file = file;
                } else {
                    String errorMessage = "Multiple files match the Clover result file pattern. One is at '" + file.getAbsolutePath() + "' the other is at '" + this.file.getAbsolutePath() + "'. Please ensure that only one clover.xml is picked up by the copy pattern.";
                    this.file = null;
                    throw new IllegalStateException(errorMessage);
                }
            }
        }

        @Nullable
        private File getFile() {
            return this.file;
        }
    }
}

