/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.builder.command;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.clover.CloverPluginHelper;
import com.atlassian.bamboo.clover.builder.command.AbstractCloverCommandDecorator;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.clover.api.ci.CIOptions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.openclover.ci.MavenIntegrator;

public class CloverMavenCommandDecorator
extends AbstractCloverCommandDecorator {
    public static final String MAVEN_CLOVER_REPOSITORY_POLLUTION_PROTECTION = "maven.clover.repositoryPollutionProtection";
    public static final String PROTECTION_DISABLED_PROPERTY = "-Dmaven.clover.repositoryPollutionProtection=false";
    public static final String NO_INTEGRATION_WARNING = "CLOVER: Detected that your Maven task runs 'install' or 'deploy' phase. Automatic Clover integration has been disabled to avoid repository pollution with instrumented code. Please:  1) change your Maven task to run a build till the 'verify' phase (the latest) or 2) setup Clover integration manually or 3) disable this protection by -Dmaven.clover.repositoryPollutionProtection=false";

    @Override
    @NotNull
    public List<String> decorateCloverArguments(@NotNull TaskContext taskContext, @NotNull CIOptions.Builder options, @NotNull List<String> args) {
        if ((args.contains("install") || args.contains("deploy")) && !args.contains(PROTECTION_DISABLED_PROPERTY)) {
            BuildLogger buildLogger = taskContext.getBuildLogger();
            buildLogger.addErrorLogEntry(NO_INTEGRATION_WARNING);
            return args;
        }
        ArrayList<String> decoratedArgs = new ArrayList<String>(args);
        String mvnPath = (String)decoratedArgs.remove(0);
        boolean useAtlassianClover = CloverPluginHelper.isIntegrateUsingAtlassianClover(taskContext);
        if (useAtlassianClover) {
            new com.atlassian.clover.ci.MavenIntegrator(options.build()).decorateArguments(decoratedArgs);
        } else {
            new MavenIntegrator(options.build()).decorateArguments(decoratedArgs);
        }
        this.addPropertyIfNotPresent(decoratedArgs, MAVEN_CLOVER_REPOSITORY_POLLUTION_PROTECTION, "true");
        decoratedArgs.add(0, mvnPath);
        return decoratedArgs;
    }

    private void addPropertyIfNotPresent(List<String> decoratedArgs, String name, String value) {
        if (!Iterables.tryFind(decoratedArgs, (Predicate)new HasPropertyPredicate(name)).isPresent()) {
            decoratedArgs.add("-D" + name + "=" + value);
        }
    }

    @Override
    protected CIOptions.Builder createOptionsBuilder(@NotNull TaskContext taskContext) {
        return super.createOptionsBuilder(taskContext).historyDir(new File(taskContext.getWorkingDirectory(), ".cloverhistory"));
    }

    public static class HasPropertyPredicate
    implements Predicate<String> {
        private boolean isDefineBefore;
        private String name;

        public HasPropertyPredicate(String name) {
            this.name = name;
        }

        public boolean apply(String property) {
            boolean isFound = property.startsWith("-D" + this.name + "=") || property.equals("-D" + this.name) || this.isDefineBefore && property.startsWith(this.name + "=") || this.isDefineBefore && property.equals(this.name);
            this.isDefineBefore = property.equals("--define") || property.equals("-D");
            return isFound;
        }
    }
}

