/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.builder.command;

import com.atlassian.bamboo.util.SecureTemporaryFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CloverJarRetriever {
    private static final Logger log = Logger.getLogger(CloverJarRetriever.class);
    private static Pattern CLOVER_JAR_NAME_PATTERN = Pattern.compile("META-INF/lib/clover-.*\\.jar");

    private static String unpackClover(@NotNull File bambooCloverPluginPath, @NotNull File cloverJarDestination, boolean useAtlassianClover) throws IOException {
        try (ZipFile jarFile = new ZipFile(bambooCloverPluginPath);){
            Enumeration<? extends ZipEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                ZipEntry jarEntry = jarEntries.nextElement();
                if (!CloverJarRetriever.isCloverJar(jarEntry.getName()) || CloverJarRetriever.isAtlassianCloverJar(jarEntry.getName()) != useAtlassianClover) continue;
                FileUtils.copyInputStreamToFile((InputStream)jarFile.getInputStream(jarEntry), (File)cloverJarDestination);
                String string = jarEntry.getName();
                return string;
            }
        }
        throw new IllegalArgumentException("Clover jar not found in " + bambooCloverPluginPath);
    }

    private static boolean isCloverJar(@NotNull String fileName) {
        return CLOVER_JAR_NAME_PATTERN.matcher(fileName).matches();
    }

    private static boolean isAtlassianCloverJar(@NotNull String fileName) {
        return CLOVER_JAR_NAME_PATTERN.matcher(fileName).matches() && fileName.contains("4.1.2");
    }

    public static synchronized File getCloverJar(@NotNull File cloverPluginFile, boolean useAtlassianClover) throws IOException {
        String cloverJarFileName = "clover-" + cloverPluginFile.lastModified() + ".jar";
        File cloverJarFile = new File(cloverJarFileName);
        if (cloverJarFile.exists()) {
            return cloverJarFile;
        }
        cloverJarFile = SecureTemporaryFiles.create((SecureTemporaryFiles.TemporaryFileSpec)SecureTemporaryFiles.builder().setName(cloverJarFileName).setPrefer83PathsOnWindows(true).build());
        CloverJarRetriever.unpackClover(cloverPluginFile, cloverJarFile, useAtlassianClover);
        return cloverJarFile;
    }
}

