/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.builder.command;

import com.atlassian.bamboo.clover.builder.command.AbstractCloverCommandDecorator;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.clover.api.ci.CIOptions;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CloverGrailsCommandDecorator
extends AbstractCloverCommandDecorator {
    private static final String GRAILS_TEST_TARGET = "test-app";
    private static final String CLOVER_ON = "-clover.on";
    private static final String CLOVER_LICENSE_PATH = "-clover.license.path=";
    private static final String CLOVER_REPORTDIR_TARGET_CLOVER_REPORT = "-clover.reportdir=target/clover/report";
    private static final String CLOVER_JSON_OFF = "-clover.json=false";
    private static final String CLOVER_HISTORICAL_OFF = "-clover.historical=false";
    private static final String GRAILS_NON_INTERACTIVE = "-non-interactive";

    @Override
    @NotNull
    public List<String> decorateCloverArguments(@NotNull TaskContext taskContext, @NotNull CIOptions.Builder options, @NotNull List<String> args) {
        CIOptions ciOptions = options.build();
        if (args.contains(GRAILS_TEST_TARGET)) {
            args.add(CLOVER_ON);
            if (!ciOptions.isJson()) {
                args.add(this.wrapInQuotesIfWindows(CLOVER_JSON_OFF));
            }
            if (!ciOptions.isHistorical()) {
                args.add(this.wrapInQuotesIfWindows(CLOVER_HISTORICAL_OFF));
            }
            if (!args.contains(GRAILS_NON_INTERACTIVE)) {
                args.add(GRAILS_NON_INTERACTIVE);
            }
            args.add(this.wrapInQuotesIfWindows(CLOVER_REPORTDIR_TARGET_CLOVER_REPORT));
            if (ciOptions.getLicense() != null) {
                args.add(this.wrapInQuotesIfWindows(CLOVER_LICENSE_PATH + ciOptions.getLicense().getAbsolutePath()));
            }
        }
        return args;
    }

    private String wrapInQuotesIfWindows(String argument) {
        if (this.isWindowsPlatform()) {
            return "\"" + argument + "\"";
        }
        return argument;
    }
}

