/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.builder.command;

import com.atlassian.bamboo.clover.CloverPluginHelper;
import com.atlassian.bamboo.clover.builder.command.AbstractCloverCommandDecorator;
import com.atlassian.bamboo.clover.builder.command.CloverAntConfig;
import com.atlassian.bamboo.clover.builder.command.CloverJarRetriever;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.clover.api.ci.CIOptions;
import com.atlassian.clover.ci.AntIntegrator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.openclover.util.ClassPathUtil;

public class CloverAntCommandDecorator
extends AbstractCloverCommandDecorator {
    @Override
    @NotNull
    public List<String> decorateCloverArguments(@NotNull TaskContext taskContext, @NotNull CIOptions.Builder options, @NotNull List<String> args) {
        ArrayList<String> userArgs = new ArrayList<String>();
        ArrayList<String> systemArgs = new ArrayList<String>();
        CloverAntConfig antConfig = new CloverAntConfig(args, taskContext, this.capabilityContext, this.environmentVariableAccessor);
        systemArgs.addAll(antConfig.getNonDecoratedParams());
        userArgs.addAll(antConfig.getDecoratedParams());
        ArrayList<String> decoratedParams = new ArrayList<String>(userArgs);
        boolean useAtlassianClover = CloverPluginHelper.isIntegrateUsingAtlassianClover(taskContext.getBuildContext().getBuildDefinition().getCustomConfiguration());
        if (useAtlassianClover) {
            new AntIntegrator(options.build()).decorateArguments(decoratedParams);
        } else {
            new org.openclover.ci.AntIntegrator(options.build()).decorateArguments(decoratedParams);
        }
        if (this.isWindowsPlatform()) {
            decoratedParams.add("-noinput");
        }
        decoratedParams.addAll(0, systemArgs);
        try {
            this.unpackCloverJarFromOSGIBundle(decoratedParams, useAtlassianClover);
        }
        catch (IOException e) {
            throw BambooObjectUtils.asRuntimeException((Throwable)e);
        }
        return decoratedParams;
    }

    private void unpackCloverJarFromOSGIBundle(List<String> decoratedParams, boolean useAtlassianClover) throws IOException {
        String cloverJarLocation;
        String string = cloverJarLocation = useAtlassianClover ? com.atlassian.clover.util.ClassPathUtil.getCloverJarPath() : ClassPathUtil.getCloverJarPath();
        if (cloverJarLocation == null) {
            return;
        }
        File cloverJarFile = new File(cloverJarLocation);
        if (!cloverJarFile.isFile() || !cloverJarFile.getName().contains("atlassian-bamboo-plugin-clover")) {
            return;
        }
        File unpackedCloverJar = CloverJarRetriever.getCloverJar(cloverJarFile, useAtlassianClover);
        for (int i = 1; i < decoratedParams.size(); ++i) {
            if (!"-lib".equals(decoratedParams.get(i - 1)) || !decoratedParams.get(i).contains(cloverJarLocation)) continue;
            String libParam = decoratedParams.get(i);
            decoratedParams.set(i, libParam.replace(cloverJarLocation, unpackedCloverJar.getPath()));
        }
    }
}

