/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.builder.command;

import com.atlassian.bamboo.clover.CloverPluginHelper;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.plugins.TaskProcessCommandDecorator;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.clover.api.ci.CIOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCloverCommandDecorator
implements TaskProcessCommandDecorator {
    private static final Logger log = Logger.getLogger(AbstractCloverCommandDecorator.class);
    public static final String CFG_CLOVER_EXISTS = "custom.clover.exists";
    @Inject
    protected BandanaManager bandanaManager;
    @Inject
    protected CapabilityContext capabilityContext;
    @Inject
    protected EnvironmentVariableAccessor environmentVariableAccessor;

    @NotNull
    public abstract List<String> decorateCloverArguments(@NotNull TaskContext var1, @NotNull CIOptions.Builder var2, @NotNull List<String> var3);

    @NotNull
    public List<String> decorate(@NotNull TaskContext taskContext, @NotNull List<String> arguments) {
        if (this.canDecorate(taskContext)) {
            CIOptions.Builder options = this.createOptionsBuilder(taskContext);
            this.configureLicense(taskContext, options);
            return this.decorateCloverArguments(taskContext, options, arguments);
        }
        return arguments;
    }

    protected CIOptions.Builder createOptionsBuilder(@NotNull TaskContext taskContext) {
        Map<String, String> configuration = this.getCustomConfiguration(taskContext);
        return new CIOptions.Builder().historical(Boolean.parseBoolean(configuration.get("custom.clover.historical"))).json(Boolean.parseBoolean(configuration.get("custom.clover.json"))).fullClean(true).optimize(Boolean.parseBoolean(configuration.get("custom.clover.optimize")));
    }

    protected boolean canDecorate(@NotNull TaskContext taskContext) {
        Map<String, String> configuration = this.getCustomConfiguration(taskContext);
        return Boolean.parseBoolean(configuration.get(CFG_CLOVER_EXISTS)) && CloverPluginHelper.isAutoIntegrate(configuration);
    }

    protected boolean isWindowsPlatform() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    protected File getLicenseDir(@NotNull TaskContext taskContext) {
        return new File(taskContext.getWorkingDirectory(), ".clover");
    }

    protected void configureLicense(@NotNull TaskContext taskContext, @NotNull CIOptions.Builder options) {
        String licenseKey;
        if (CloverPluginHelper.hasGlobalLicenseKey(this.bandanaManager)) {
            log.debug((Object)"Using globally configured license");
            licenseKey = CloverPluginHelper.getGlobalLicenseKey(this.bandanaManager);
        } else {
            log.debug((Object)"No license configured");
            licenseKey = "";
        }
        if (StringUtils.isEmpty((CharSequence)licenseKey)) {
            log.debug((Object)"License was configured to an empty license");
            return;
        }
        File license = new File(this.getLicenseDir(taskContext), "clover.license");
        try {
            FileUtils.writeStringToFile((File)license, (String)licenseKey, (Charset)StandardCharsets.UTF_8);
            options.license(license);
            log.debug((Object)("Clover License successfully stored in " + license));
        }
        catch (IOException e) {
            if (!this.isWindowsPlatform() || !licenseKey.contains(">") && !licenseKey.contains("<")) {
                log.debug((Object)"Setting licence cert...");
                options.licenseCert(licenseKey);
            }
            log.warn((Object)("No clover.license file set due to: " + e.getMessage()), (Throwable)e);
        }
    }

    protected boolean isEnabled(Map<String, String> configuration) {
        return CloverPluginHelper.isAutoIntegrate(configuration);
    }

    @NotNull
    protected Map<String, String> getCustomConfiguration(@NotNull TaskContext taskContext) {
        Map customConfiguration = taskContext.getBuildContext().getBuildDefinition().getCustomConfiguration();
        if (customConfiguration != null) {
            return customConfiguration;
        }
        return Collections.emptyMap();
    }

    @Deprecated
    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    @Deprecated
    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }

    @Deprecated
    public void setEnvironmentVariableAccessor(EnvironmentVariableAccessor environmentVariableAccessor) {
        this.environmentVariableAccessor = environmentVariableAccessor;
    }
}

