/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.build.coverage;

import com.atlassian.bamboo.build.FilterController;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.clover.build.coverage.CloverReportLinker;
import com.atlassian.bamboo.clover.build.coverage.ReportProvider;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.reports.collector.ReportCollector;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.ww2.actions.ChainActionSupport;
import com.atlassian.bamboo.ww2.aware.ResultsListAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.xwork.ParameterSafe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfree.data.xy.XYDataset;

public class ViewCloverCoverageSummary
extends ChainActionSupport
implements ResultsListAware,
PlanReadSecurityAware {
    PluginAccessor pluginAccessor;
    List<ResultsSummary> resultsList;
    XYDataset dataset;
    String reportKey = "com.atlassian.bamboo.plugin.clover:cloverCoverage";
    FilterController filterController;
    private static final String PLUGIN_KEY = "com.atlassian.bamboo.plugin.clover";
    private ArtifactLinkManager artifactLinkManager;

    public String doViewCoverage() throws Exception {
        this.setReportKey("com.atlassian.bamboo.plugin.clover:cloverCoverage");
        return this.run();
    }

    public String doViewLinesOfCode() throws Exception {
        this.setReportKey("com.atlassian.bamboo.plugin.clover:cloverLinesOfCode");
        return this.run();
    }

    public String doViewNonCommentLinesOfCode() throws Exception {
        this.setReportKey("com.atlassian.bamboo.plugin.clover:cloverNonCommentLinesOfCode");
        return this.run();
    }

    public String execute() throws Exception {
        return this.run();
    }

    private String run() {
        ModuleDescriptor descriptor;
        if (this.resultsList != null && !this.resultsList.isEmpty() && (descriptor = this.pluginAccessor.getPluginModule(this.getReportKey())) != null) {
            ReportCollector collector = (ReportCollector)descriptor.getModule();
            collector.setResultsList(this.getResultsList());
            collector.setParams(Collections.emptyMap());
            this.dataset = (XYDataset)collector.getDataset();
        }
        return "success";
    }

    @Nullable
    public ReportProvider getReportLinker() {
        ResultsSummary resultsSummary = this.getMutablePlan().getLatestResultsSummary();
        if (resultsSummary != null) {
            return new CloverReportLinker(resultsSummary, this.artifactLinkManager, this.getBaseUrl());
        }
        return null;
    }

    public List<ResultsSummary> getResultsList() {
        return this.resultsList;
    }

    public void setResultsList(List<? extends ResultsSummary> resultsList) {
        this.resultsList = new ArrayList<ResultsSummary>(resultsList);
    }

    public boolean isMoreThanOneDataPoint() {
        return this.dataset != null && this.dataset.getSeriesCount() > 0 && this.dataset.getItemCount(0) > 1;
    }

    public XYDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(XYDataset dataset) {
        this.dataset = dataset;
    }

    public String getReportKey() {
        return this.reportKey;
    }

    public void setReportKey(String reportKey) {
        this.reportKey = reportKey;
    }

    @NotNull
    public String getJobName(PlanKey jobResultKey) {
        ImmutablePlan immutableJob = this.cachedPlanManager.getPlanByKey(jobResultKey);
        return immutableJob != null ? immutableJob.getBuildName() : jobResultKey.getKey();
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @ParameterSafe
    public FilterController getFilterController() {
        return this.filterController;
    }

    public void setFilterController(FilterController filterController) {
        this.filterController = filterController;
    }

    public void setArtifactLinkManager(ArtifactLinkManager artifactLinkManager) {
        this.artifactLinkManager = artifactLinkManager;
    }
}

