/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.build.coverage;

import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class CloverResultWebItemCondition
implements Condition {
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Inject
    private ResultsSummaryManager resultsSummaryManager;

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        String planKey = StringUtils.defaultString((String)((String)context.get("planKey")), (String)((String)context.get("buildKey")));
        String buildNumber = (String)context.get("buildNumber");
        if (planKey == null || buildNumber == null) {
            return false;
        }
        ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)planKey));
        if (plan == null) {
            return false;
        }
        int number = Integer.parseInt(buildNumber);
        ResultsSummary summary = this.resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey((String)plan.getKey(), (int)number));
        if (summary == null) {
            return false;
        }
        Map customData = summary.getCustomBuildData();
        return customData.containsKey("CLOVER_BUILD_COVERAGE");
    }

    @Deprecated
    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    @Deprecated
    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

