/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.build.coverage;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.artifact.MutableArtifact;
import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDataProvider;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.clover.build.coverage.ReportProvider;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.Narrow;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloverReportLinker
implements ReportProvider {
    private static final Logger log = Logger.getLogger(CloverReportLinker.class);
    public static final String REPORT_DATE_FORMAT = "HH:mm:ss dd MMM yyyy";
    private final Collection<Artifact> artifacts = new ArrayList<Artifact>();
    private final ImmutableResultsSummary buildResultsSummary;
    private final ArtifactLinkManager artifactLinkManager;
    private final String baseUrl;

    public CloverReportLinker(@NotNull ResultsSummary summary, @NotNull ArtifactLinkManager artifactLinkManager, @NotNull String baseUrl) {
        this.buildResultsSummary = summary;
        this.artifactLinkManager = artifactLinkManager;
        this.baseUrl = baseUrl;
        if (summary instanceof ChainResultsSummary) {
            Stream<MutableArtifact> allArtifactLinksInChain = ((ChainResultsSummary)summary).getStageResults().stream().flatMap(stageResult -> stageResult.getSortedBuildResults().stream()).flatMap(buildResult -> buildResult.getProducedArtifactLinks().stream());
            allArtifactLinksInChain.map(ArtifactLink::getArtifact).forEach(this.artifacts::add);
        } else {
            this.artifacts.addAll(this.getLocalArtifactsLinks(summary));
            this.artifacts.addAll(this.getSharedArtifactsLinks(summary));
        }
    }

    @NotNull
    private Collection<Artifact> getLocalArtifactsLinks(@NotNull ResultsSummary summary) {
        return this.artifactLinkManager.getArtifactLinks(summary, null).stream().map(ArtifactLink::getArtifact).collect(Collectors.toCollection(ArrayList::new));
    }

    @NotNull
    private Collection<Artifact> getSharedArtifactsLinks(@NotNull ResultsSummary summary) {
        BuildResultsSummary buildSummary = (BuildResultsSummary)Narrow.downTo((Object)summary, BuildResultsSummary.class);
        if (buildSummary == null) {
            return Collections.emptyList();
        }
        ChainResultsSummary chainSummary = buildSummary.getChainResultsSummary();
        if (chainSummary == null) {
            return Collections.emptyList();
        }
        Predicate<ArtifactLink> isProducerJob = artifactLink -> summary.equals(artifactLink.getProducerJobResult());
        return this.artifactLinkManager.getArtifactLinks((ResultsSummary)chainSummary, null).stream().filter(isProducerJob).map(ArtifactLink::getArtifact).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    @Deprecated
    @Nullable
    public String getCloverReportUrl() {
        Artifact artifact = this.getLatestCloverArtifact();
        if (artifact == null) {
            return null;
        }
        return this.getCloverReportUrl(artifact);
    }

    @Override
    @Nullable
    public String getCloverReportUrl(@NotNull Artifact artifact) {
        return ArtifactHandlingUtils.getArtifactUrl((ArtifactLinkManager)this.artifactLinkManager, (Artifact)artifact, (String)this.baseUrl);
    }

    @Override
    @NotNull
    public ImmutableResultsSummary getBuildResultsSummary() {
        return this.buildResultsSummary;
    }

    @Override
    @Deprecated
    @NotNull
    public String getTimestamp() {
        Artifact artifact = this.getLatestCloverArtifact();
        if (artifact != null) {
            return this.getTimestamp(artifact);
        }
        return "";
    }

    @Override
    @NotNull
    public String getTimestamp(@NotNull Artifact artifact) {
        ArtifactLinkDataProvider artifactLinkDataProvider = this.artifactLinkManager.getArtifactLinkDataProvider(artifact);
        if (artifactLinkDataProvider == null) {
            return "";
        }
        Date ts = artifactLinkDataProvider.lastModified();
        return ts == null ? "" : new SimpleDateFormat(REPORT_DATE_FORMAT).format(ts);
    }

    @Override
    public boolean isCloverReport(@NotNull Artifact artifact) {
        if (artifact.getLabel().startsWith("Clover Report")) {
            return true;
        }
        ArtifactLinkDataProvider artifactLinkDataProvider = this.artifactLinkManager.getArtifactLinkDataProvider(artifact);
        return artifactLinkDataProvider != null && artifactLinkDataProvider.exists() && artifactLinkDataProvider.exists(Arrays.asList("img", "clover.ico"));
    }

    @Override
    public boolean isCloverAdgReport(@NotNull Artifact artifact) {
        ArtifactLinkDataProvider artifactLinkDataProvider = this.artifactLinkManager.getArtifactLinkDataProvider(artifact);
        return artifactLinkDataProvider != null && artifactLinkDataProvider.exists() && artifactLinkDataProvider.exists(Arrays.asList("img", "clover.ico")) && artifactLinkDataProvider.exists(Arrays.asList("aui", "css", "aui.min.css"));
    }

    @Nullable
    private Artifact getLatestCloverArtifact() {
        return this.artifacts.stream().filter(this::isCloverReport).findFirst().orElse(null);
    }

    @Override
    @NotNull
    public Collection<Artifact> getCloverArtifacts() {
        return this.artifacts.stream().filter(this::isCloverReport).collect(Collectors.toCollection(ArrayList::new));
    }
}

