/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.build.coverage;

import com.atlassian.bamboo.clover.CloverPluginHelper;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class CloverBuildWebItemCondition
implements Condition {
    @Inject
    private CachedPlanManager cachedPlanManager;

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        String buildKey = StringUtils.defaultString((String)((String)context.get("planKey")), (String)((String)context.get("buildKey")));
        if (buildKey == null) {
            return false;
        }
        ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)buildKey), ImmutablePlan.class);
        if (plan == null) {
            return false;
        }
        ImmutableChain chain = (ImmutableChain)Narrow.to((Object)plan, ImmutableChain.class);
        if (chain != null) {
            return chain.getAllJobs().stream().anyMatch(CloverPluginHelper.isCloverEnabledForPlan);
        }
        return CloverPluginHelper.isCloverEnabledForPlan.test(plan);
    }

    @Deprecated
    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }
}

