/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.clover.build;

import com.atlassian.bamboo.clover.build.AbstractGrailsCloverIntegrator;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.xml.BambooXmlUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class GrailsCloverPomIntegrator
extends AbstractGrailsCloverIntegrator {
    private static final Logger log = Logger.getLogger(GrailsCloverPomIntegrator.class);

    public GrailsCloverPomIntegrator(@NotNull String pluginVersion) {
        super(pluginVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean integrate(@NotNull File xmlFile) throws Exception {
        boolean ret;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
        FileInputStream input = null;
        try {
            input = new FileInputStream(xmlFile);
            ret = this.integrate(input, buffer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(xmlFile);
            ((OutputStream)output).write(buffer.toByteArray());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)output);
        return ret;
    }

    @Nullable
    private static Element getElement(@NotNull Document doc, @NotNull String name) {
        NodeList elements = doc.getElementsByTagName(name);
        if (elements.getLength() > 0) {
            return (Element)Narrow.to((Object)elements.item(0), Element.class);
        }
        return null;
    }

    @Nullable
    private static Element getElement(@NotNull Element doc, @NotNull String name) {
        NodeList elements = doc.getElementsByTagName(name);
        if (elements.getLength() > 0) {
            return (Element)Narrow.to((Object)elements.item(0), Element.class);
        }
        return null;
    }

    @Nullable
    private static Element createElementWithText(@NotNull Document doc, @NotNull String name, @NotNull String text) {
        Element element = doc.createElement(name);
        element.appendChild(doc.createTextNode(text));
        return element;
    }

    private static void write(@NotNull Document dom, @NotNull OutputStream output) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS domImplLS = (DOMImplementationLS)Narrow.to((Object)registry.getDOMImplementation("LS"), DOMImplementationLS.class);
        if (domImplLS == null) {
            log.error((Object)"Failed to find DOMImplementationLS in the registry");
            return;
        }
        LSOutput lsOutput = domImplLS.createLSOutput();
        lsOutput.setByteStream(output);
        LSSerializer serializer = domImplLS.createLSSerializer();
        serializer.write(dom, lsOutput);
    }

    protected boolean isAlreadyIntegrated(@NotNull Element dependenciesElem) {
        NodeList childNodes = dependenciesElem.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 8 || node.getTextContent() == null || !node.getTextContent().contains("ADDED BY CLOVER")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean integrate(@NotNull InputStream input, @NotNull OutputStream output) throws Exception {
        DocumentBuilderFactory dbf = BambooXmlUtils.newSecureDocumentBuilderFactory((Logger)log);
        Document doc = dbf.newDocumentBuilder().parse(input);
        Element projectElem = GrailsCloverPomIntegrator.getElement(doc, "project");
        if (projectElem == null) {
            return false;
        }
        Element dependenciesElem = GrailsCloverPomIntegrator.getElement(projectElem, "dependencies");
        if (dependenciesElem == null) {
            dependenciesElem = (Element)Narrow.to((Object)projectElem.appendChild(doc.createElement("dependencies")), Element.class);
        }
        boolean modified = false;
        if (dependenciesElem != null && !this.isAlreadyIntegrated(dependenciesElem)) {
            dependenciesElem.appendChild(doc.createTextNode("\n"));
            dependenciesElem.appendChild(doc.createComment(" ADDED BY CLOVER "));
            dependenciesElem.appendChild(doc.createTextNode("\n"));
            dependenciesElem.appendChild(this.getGrailsCloverPluginDependency(doc));
            dependenciesElem.appendChild(doc.createTextNode("\n"));
            dependenciesElem.appendChild(this.getCloverCoreDependency(doc));
            dependenciesElem.appendChild(doc.createTextNode("\n"));
            dependenciesElem.appendChild(doc.createComment(" ADDED BY CLOVER "));
            dependenciesElem.appendChild(doc.createTextNode("\n"));
            modified = true;
        }
        GrailsCloverPomIntegrator.write(doc, output);
        return modified;
    }

    @NotNull
    protected Element getCloverCoreDependency(@NotNull Document document) {
        return GrailsCloverPomIntegrator.createDependencyElement(document, this.getCloverCoreGroupId(), this.getCloverCoreArtifactId(), this.getPluginVersion(), "compile", "jar");
    }

    @NotNull
    protected Element getGrailsCloverPluginDependency(@NotNull Document document) {
        return GrailsCloverPomIntegrator.createDependencyElement(document, "org.grails.plugins", "clover", this.getPluginVersion(), "compile", "zip");
    }

    @NotNull
    static Element createDependencyElement(@NotNull Document doc, @NotNull String groupId, @NotNull String artifactId, @Nullable String version, @Nullable String scope, @Nullable String type) {
        Element dependency = doc.createElement("dependency");
        dependency.appendChild(GrailsCloverPomIntegrator.createElementWithText(doc, "groupId", groupId));
        dependency.appendChild(GrailsCloverPomIntegrator.createElementWithText(doc, "artifactId", artifactId));
        if (version != null) {
            dependency.appendChild(GrailsCloverPomIntegrator.createElementWithText(doc, "version", version));
        }
        if (scope != null) {
            dependency.appendChild(GrailsCloverPomIntegrator.createElementWithText(doc, "scope", scope));
        }
        if (type != null) {
            dependency.appendChild(GrailsCloverPomIntegrator.createElementWithText(doc, "type", type));
        }
        return dependency;
    }
}

